/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public abstract class PersistentUpdater {
    private final PersistentModel preferences;
    protected final String name;
    protected final IProject project;

    public PersistentUpdater(IProject project, String name) {
        this.project = project;
        this.name = name;
        this.preferences = CorePlugin.modelPersistence().loadModel(project);
    }

    protected Collection<String> getKnownItems() throws CoreException {
        String serializedForm = this.preferences.getValue(this.name, null);
        if (serializedForm == null) {
            return Collections.emptyList();
        }
        return Splitter.on((String)File.pathSeparator).omitEmptyStrings().splitToList((CharSequence)serializedForm);
    }

    protected void setKnownItems(Collection<String> items) throws CoreException {
        this.preferences.setValue(this.name, Joiner.on((String)File.pathSeparator).join(items));
        this.preferences.flush();
    }
}

