/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.extension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.invocation.InvocationCustomizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public final class InvocationCustomizerCollector
implements InvocationCustomizer {
    private List<InvocationCustomizer> customizers;

    @Override
    public List<String> getExtraArguments() {
        if (this.customizers == null) {
            this.customizers = this.loadCustomizers();
        }
        return InvocationCustomizerCollector.collectArguments(this.customizers);
    }

    private List<InvocationCustomizer> loadCustomizers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.buildship.core", "invocationcustomizers");
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            try {
                result.add(InvocationCustomizer.class.cast(element.createExecutableExtension("class")));
                continue;
            }
            catch (CoreException e) {
                CorePlugin.logger().warn("Can't load contributed invocation customizers", e);
            }
        }
        return result;
    }

    private static List<String> collectArguments(List<InvocationCustomizer> customizers) {
        ArrayList result = Lists.newArrayList();
        for (InvocationCustomizer customizer : customizers) {
            result.addAll(customizer.getExtraArguments());
        }
        return result;
    }
}

