/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.preferences.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.event.Event;
import org.eclipse.buildship.core.event.EventListener;
import org.eclipse.buildship.core.preferences.ModelPersistence;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.preferences.internal.DefaultPersistentModel;
import org.eclipse.buildship.core.workspace.ProjectDeletedEvent;
import org.eclipse.buildship.core.workspace.ProjectMovedEvent;
import org.eclipse.core.resources.IProject;
import org.gradle.internal.UncheckedException;

public final class DefaultModelPersistence
implements ModelPersistence,
EventListener {
    private DefaultModelPersistence() {
    }

    @Override
    public PersistentModel loadModel(IProject project) {
        try {
            return this.loadProjectPrefsChecked(project);
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    private PersistentModel loadProjectPrefsChecked(IProject project) throws IOException {
        File preferencesFile = DefaultModelPersistence.preferencesFile(project);
        if (preferencesFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(DefaultModelPersistence.preferencesFile(project)), Charsets.UTF_8);){
                Properties props = new Properties();
                props.load(reader);
                HashMap preferences = Maps.newHashMap();
                for (Object propKey : props.keySet()) {
                    preferences.put(propKey.toString(), props.get(propKey).toString());
                }
                DefaultPersistentModel defaultPersistentModel = new DefaultPersistentModel(this, project, preferences);
                return defaultPersistentModel;
            }
        }
        return new DefaultPersistentModel(this, project, Collections.emptyMap());
    }

    void persistPrefs(DefaultPersistentModel preferences) {
        try {
            this.persistPrefsChecked(preferences);
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    private void persistPrefsChecked(DefaultPersistentModel preferences) throws IOException {
        Map<String, String> added = preferences.getAdded();
        Set<String> removed = preferences.getRemoved();
        if (!added.isEmpty() || !removed.isEmpty()) {
            File preferencesFile = DefaultModelPersistence.preferencesFile(preferences.getProject());
            if (!preferencesFile.exists()) {
                Files.createParentDirs((File)preferencesFile);
                Files.touch((File)preferencesFile);
            }
            Properties props = new Properties();
            try (Iterator<String> reader = new InputStreamReader((InputStream)new FileInputStream(preferencesFile), Charsets.UTF_8);){
                props.load((Reader)((Object)reader));
            }
            for (String key : removed) {
                props.remove(key);
            }
            for (String key : added.keySet()) {
                props.put(key, added.get(key));
            }
            var7_7 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(preferencesFile), Charsets.UTF_8);){
                props.store(writer, "");
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
        }
    }

    @Override
    public void onEvent(Event event) {
        try {
            if (event instanceof ProjectMovedEvent) {
                this.movePreferencesFile((ProjectMovedEvent)event);
            } else if (event instanceof ProjectDeletedEvent) {
                this.deleteProjectPreferences((ProjectDeletedEvent)event);
            }
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    private void movePreferencesFile(ProjectMovedEvent event) throws IOException {
        File preferencesFile = DefaultModelPersistence.preferencesFile(event.getPreviousName());
        if (preferencesFile.exists()) {
            Files.move((File)preferencesFile, (File)DefaultModelPersistence.preferencesFile(event.getProject().getName()));
        }
    }

    private void deleteProjectPreferences(ProjectDeletedEvent event) {
        DefaultModelPersistence.preferencesFile(event.getProject()).delete();
    }

    private static File preferencesFile(IProject project) {
        return DefaultModelPersistence.preferencesFile(project.getName());
    }

    private static File preferencesFile(String projectName) {
        return CorePlugin.getInstance().getStateLocation().append("project-preferences").append(projectName).toFile();
    }

    public static DefaultModelPersistence createAndRegister() {
        DefaultModelPersistence persistence = new DefaultModelPersistence();
        CorePlugin.listenerRegistry().addEventListener(persistence);
        return persistence;
    }

    public void close() {
        CorePlugin.listenerRegistry().removeEventListener(this);
    }
}

