/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import org.eclipse.buildship.ui.util.color.ColorUtils;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;

public final class TaskDescriptionLabelProvider
extends ColumnLabelProvider {
    private final Color descriptionColor = ColorUtils.getDecorationsColorFromCurrentTheme();

    public String getText(Object element) {
        if (element instanceof ProjectNode) {
            return this.getProjectTaskText((ProjectNode)element);
        }
        if (element instanceof ProjectTaskNode) {
            return this.getProjectTaskText((ProjectTaskNode)element);
        }
        if (element instanceof TaskSelectorNode) {
            return this.getTaskSelectorText((TaskSelectorNode)element);
        }
        if (element instanceof TaskGroupNode) {
            return this.getTaskGroupText((TaskGroupNode)element);
        }
        throw new IllegalStateException(String.format("Unknown element type of element %s.", element));
    }

    private String getProjectTaskText(ProjectNode projectNode) {
        return projectNode.getEclipseProject().getDescription();
    }

    private String getTaskGroupText(TaskGroupNode taskGroup) {
        return "";
    }

    private String getProjectTaskText(ProjectTaskNode projectTask) {
        return projectTask.getProjectTask().getDescription();
    }

    private String getTaskSelectorText(TaskSelectorNode taskSelector) {
        return taskSelector.getTaskSelector().getDescription();
    }

    public Color getForeground(Object element) {
        return this.descriptionColor;
    }
}

