/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseLinkedResource;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.OmniJavaSourceSettings;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.util.file.RelativePathUtils;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.BuildCommandUpdater;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.buildship.core.workspace.internal.DerivedResourcesUpdater;
import org.eclipse.buildship.core.workspace.internal.JavaSourceSettingsUpdater;
import org.eclipse.buildship.core.workspace.internal.LinkedResourcesUpdater;
import org.eclipse.buildship.core.workspace.internal.ProjectNameUpdater;
import org.eclipse.buildship.core.workspace.internal.ProjectNatureUpdater;
import org.eclipse.buildship.core.workspace.internal.SourceFolderUpdater;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

final class SynchronizeGradleBuildOperation
implements IWorkspaceRunnable {
    private final OmniEclipseGradleBuild gradleBuild;
    private final FixedRequestAttributes requestAttributes;
    private final NewProjectHandler newProjectHandler;

    SynchronizeGradleBuildOperation(OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes requestAttributes, NewProjectHandler newProjectHandler) {
        this.gradleBuild = gradleBuild;
        this.requestAttributes = requestAttributes;
        this.newProjectHandler = newProjectHandler;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SynchronizeGradleBuildOperation.this.synchronizeGradleBuildWithWorkspace(monitor);
            }
        }, (IProgressMonitor)monitor);
    }

    private void synchronizeGradleBuildWithWorkspace(IProgressMonitor monitor) throws CoreException {
        List<OmniEclipseProject> allGradleProjects = this.getAllGradleProjects();
        List<IProject> decoupledWorkspaceProjects = this.getOpenWorkspaceProjectsRemovedFromGradleBuild();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(decoupledWorkspaceProjects.size() + allGradleProjects.size()));
        for (IProject project : decoupledWorkspaceProjects) {
            this.uncoupleWorkspaceProjectFromGradle(project, progress.newChild(1));
        }
        for (OmniEclipseProject gradleProject : allGradleProjects) {
            this.synchronizeGradleProjectWithWorkspaceProject(gradleProject, progress.newChild(1));
        }
    }

    private List<IProject> getOpenWorkspaceProjectsRemovedFromGradleBuild() {
        ImmutableSet gradleProjectDirectories = FluentIterable.from(this.getAllGradleProjects()).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject gradleProject) {
                return gradleProject.getProjectDirectory();
            }
        }).toSet();
        ImmutableList<IProject> allWorkspaceProjects = CorePlugin.workspaceOperations().getAllProjects();
        return FluentIterable.from(allWorkspaceProjects).filter(GradleProjectNature.isPresentOn()).filter((Predicate)new Predicate<IProject>((Set)gradleProjectDirectories){
            final /* synthetic */ Set val$gradleProjectDirectories;
            {
                this.val$gradleProjectDirectories = set;
            }

            public boolean apply(IProject project) {
                ProjectConfiguration projectConfiguration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
                return projectConfiguration.getRequestAttributes().getProjectDir().equals(SynchronizeGradleBuildOperation.this.requestAttributes.getProjectDir()) && (project.getLocation() == null || !this.val$gradleProjectDirectories.contains(project.getLocation().toFile()));
            }
        }).toList();
    }

    private void synchronizeGradleProjectWithWorkspaceProject(OmniEclipseProject project, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(1);
        progress.subTask(String.format("Synchronize Gradle project %s with workspace project", project.getName()));
        Optional<IProject> workspaceProject = CorePlugin.workspaceOperations().findProjectByLocation(project.getProjectDirectory());
        SubMonitor childProgress = progress.newChild(1, 7);
        if (workspaceProject.isPresent()) {
            this.synchronizeWorkspaceProject(project, (IProject)workspaceProject.get(), childProgress);
        } else if (project.getProjectDirectory().exists() && this.newProjectHandler.shouldImport(project)) {
            this.synchronizeNonWorkspaceProject(project, childProgress);
        }
    }

    private void synchronizeWorkspaceProject(OmniEclipseProject project, IProject workspaceProject, SubMonitor progress) throws CoreException {
        if (workspaceProject.isAccessible()) {
            this.synchronizeOpenWorkspaceProject(project, workspaceProject, progress);
        } else {
            this.synchronizeClosedWorkspaceProject(progress);
        }
    }

    private void synchronizeOpenWorkspaceProject(OmniEclipseProject project, IProject workspaceProject, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(12);
        CorePlugin.workspaceOperations().refreshProject(workspaceProject, (IProgressMonitor)progress.newChild(1));
        workspaceProject = ProjectNameUpdater.updateProjectName(workspaceProject, project, this.gradleBuild, (IProgressMonitor)progress.newChild(1));
        CorePlugin.workspaceOperations().addNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)progress.newChild(1));
        if (this.requestAttributes != null) {
            ProjectConfiguration configuration = ProjectConfiguration.from(this.requestAttributes, project);
            CorePlugin.projectConfigurationManager().saveProjectConfiguration(configuration, workspaceProject);
        }
        LinkedResourcesUpdater.update(workspaceProject, project.getLinkedResources(), (IProgressMonitor)progress.newChild(1));
        this.markDerivedFolders(project, workspaceProject, progress.newChild(1));
        SubMonitor javaProgress = progress.newChild(4);
        if (this.isJavaProject(project)) {
            IJavaProject javaProject;
            if (this.hasJavaNature(workspaceProject)) {
                javaProgress.newChild(1);
                javaProject = JavaCore.create((IProject)workspaceProject);
            } else {
                IPath jrePath = JavaRuntime.getDefaultJREContainerEntry().getPath();
                IClasspathEntry classpathContainer = GradleClasspathContainer.newClasspathEntry();
                javaProject = CorePlugin.workspaceOperations().createJavaProject(workspaceProject, jrePath, classpathContainer, (IProgressMonitor)javaProgress.newChild(1));
            }
            JavaSourceSettingsUpdater.update(javaProject, (OmniJavaSourceSettings)project.getJavaSourceSettings().get(), (IProgressMonitor)javaProgress.newChild(1));
            SourceFolderUpdater.update(javaProject, project.getSourceDirectories(), (IProgressMonitor)javaProgress.newChild(1));
            ClasspathContainerUpdater.updateFromModel(javaProject, project, (IProgressMonitor)javaProgress.newChild(1));
        }
        ProjectNatureUpdater.update(workspaceProject, (Optional<List<OmniEclipseProjectNature>>)project.getProjectNatures(), (IProgressMonitor)progress.newChild(1));
        BuildCommandUpdater.update(workspaceProject, (Optional<List<OmniEclipseBuildCommand>>)project.getBuildCommands(), (IProgressMonitor)progress.newChild(1));
    }

    private void synchronizeClosedWorkspaceProject(SubMonitor childProgress) {
    }

    private void synchronizeNonWorkspaceProject(OmniEclipseProject project, SubMonitor progress) throws CoreException {
        IProject workspaceProject;
        progress.setWorkRemaining(2);
        Optional<IProjectDescription> projectDescription = CorePlugin.workspaceOperations().findProjectDescriptor(project.getProjectDirectory(), (IProgressMonitor)progress.newChild(1));
        if (projectDescription.isPresent()) {
            if (this.newProjectHandler.shouldOverwriteDescriptor((IProjectDescription)projectDescription.get(), project)) {
                CorePlugin.workspaceOperations().deleteProjectDescriptors(project.getProjectDirectory());
                workspaceProject = this.addNewEclipseProjectToWorkspace(project, progress.newChild(1));
            } else {
                workspaceProject = this.addExistingEclipseProjectToWorkspace(project, (IProjectDescription)projectDescription.get(), progress.newChild(1));
            }
        } else {
            workspaceProject = this.addNewEclipseProjectToWorkspace(project, progress.newChild(1));
        }
        this.newProjectHandler.afterImport(workspaceProject, project);
    }

    private IProject addExistingEclipseProjectToWorkspace(OmniEclipseProject project, IProjectDescription projectDescription, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(3);
        ProjectNameUpdater.ensureProjectNameIsFree(project, this.gradleBuild, (IProgressMonitor)progress.newChild(1));
        IProject workspaceProject = CorePlugin.workspaceOperations().includeProject(projectDescription, (List<String>)ImmutableList.of(), (IProgressMonitor)progress.newChild(1));
        this.synchronizeOpenWorkspaceProject(project, workspaceProject, progress.newChild(1));
        return workspaceProject;
    }

    private IProject addNewEclipseProjectToWorkspace(OmniEclipseProject project, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(3);
        ProjectNameUpdater.ensureProjectNameIsFree(project, this.gradleBuild, (IProgressMonitor)progress.newChild(1));
        IProject workspaceProject = CorePlugin.workspaceOperations().createProject(project.getName(), project.getProjectDirectory(), (List<String>)ImmutableList.of(), (IProgressMonitor)progress.newChild(1));
        this.synchronizeOpenWorkspaceProject(project, workspaceProject, progress.newChild(1));
        return workspaceProject;
    }

    private List<IFolder> getNestedSubProjectFolders(OmniEclipseProject project, IProject workspaceProject) {
        ArrayList subProjectFolders = Lists.newArrayList();
        IPath parentPath = workspaceProject.getLocation();
        for (OmniEclipseProject child : project.getChildren()) {
            IPath childPath = Path.fromOSString((String)child.getProjectDirectory().getPath());
            if (!parentPath.isPrefixOf(childPath)) continue;
            IPath relativePath = RelativePathUtils.getRelativePath(parentPath, childPath);
            subProjectFolders.add(workspaceProject.getFolder(relativePath));
        }
        return subProjectFolders;
    }

    private void markDerivedFolders(OmniEclipseProject gradleProject, IProject workspaceProject, SubMonitor progress) {
        ArrayList derivedResources = Lists.newArrayList();
        derivedResources.add(".gradle");
        Optional<IFolder> possibleBuildDirectory = this.getBuildDirectory(gradleProject, workspaceProject);
        if (possibleBuildDirectory.isPresent()) {
            IFolder buildDirectory = (IFolder)possibleBuildDirectory.get();
            derivedResources.add(buildDirectory.getName());
            if (buildDirectory.exists()) {
                CorePlugin.workspaceOperations().markAsBuildFolder(buildDirectory);
            }
        }
        for (IFolder subProjectFolder : this.getNestedSubProjectFolders(gradleProject, workspaceProject)) {
            derivedResources.add(subProjectFolder.getName());
            if (!subProjectFolder.exists()) continue;
            CorePlugin.workspaceOperations().markAsSubProject(subProjectFolder);
        }
        DerivedResourcesUpdater.update(workspaceProject, derivedResources, (IProgressMonitor)progress);
    }

    private Optional<IFolder> getBuildDirectory(OmniEclipseProject project, IProject workspaceProject) {
        OmniGradleProject gradleProject = project.getGradleProject();
        Maybe buildDirectory = gradleProject.getBuildDirectory();
        if (buildDirectory.isPresent() && buildDirectory.get() != null) {
            Path buildDirLocation = new Path(((File)buildDirectory.get()).getPath());
            return this.normalizeBuildDirectory(buildDirLocation, workspaceProject, project);
        }
        return Optional.of((Object)workspaceProject.getFolder("build"));
    }

    private Optional<IFolder> normalizeBuildDirectory(Path buildDirLocation, IProject workspaceProject, OmniEclipseProject project) {
        IPath projectLocation = workspaceProject.getLocation();
        if (projectLocation.isPrefixOf((IPath)buildDirLocation)) {
            IPath relativePath = RelativePathUtils.getRelativePath(projectLocation, (IPath)buildDirLocation);
            return Optional.of((Object)workspaceProject.getFolder(relativePath));
        }
        for (OmniEclipseLinkedResource linkedResource : project.getLinkedResources()) {
            if (!buildDirLocation.toString().equals(linkedResource.getLocation())) continue;
            return Optional.of((Object)workspaceProject.getFolder(linkedResource.getName()));
        }
        return Optional.absent();
    }

    private boolean isJavaProject(OmniEclipseProject project) {
        return project.getJavaSourceSettings().isPresent();
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    private void uncoupleWorkspaceProjectFromGradle(IProject workspaceProject, SubMonitor monitor) {
        monitor.setWorkRemaining(3);
        monitor.subTask(String.format("Uncouple workspace project %s from Gradle", workspaceProject.getName()));
        CorePlugin.workspaceOperations().refreshProject(workspaceProject, (IProgressMonitor)monitor.newChild(1, 7));
        CorePlugin.workspaceOperations().removeNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)monitor.newChild(1, 7));
        DerivedResourcesUpdater.clear(workspaceProject, (IProgressMonitor)monitor.newChild(1, 7));
        CorePlugin.projectConfigurationManager().deleteProjectConfiguration(workspaceProject);
    }

    private List<OmniEclipseProject> getAllGradleProjects() {
        return this.gradleBuild.getRootEclipseProject().getAll();
    }
}

