/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public final class GradleClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject javaProject) {
        this.loadClasspath(javaProject);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject javaProject, IClasspathContainer containerSuggestion) {
        this.loadClasspath(javaProject);
    }

    private void loadClasspath(IJavaProject javaProject) {
        boolean updatedFromStorage;
        IProject project = javaProject.getProject();
        if (!GradleProjectNature.isPresentOn(project)) {
            return;
        }
        try {
            updatedFromStorage = ClasspathContainerUpdater.updateFromStorage(javaProject, null);
        }
        catch (JavaModelException e) {
            throw new GradlePluginsRuntimeException("Could not initialize Gradle classpath container.", e);
        }
        if (!updatedFromStorage) {
            this.updateFromGradleProject(javaProject);
        }
    }

    private void updateFromGradleProject(IJavaProject project) {
        CorePlugin.gradleWorkspaceManager().synchronizeProjects((Set<IProject>)ImmutableSet.of((Object)project.getProject()), NewProjectHandler.NO_OP);
    }
}

