/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.edit.command.DeleteSelectionCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class DeleteSelectionCommandHandler
implements ILayerCommandHandler<DeleteSelectionCommand> {
    private final SelectionLayer selectionLayer;
    private IUniqueIndexLayer upperLayer;

    public DeleteSelectionCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null);
    }

    public DeleteSelectionCommandHandler(SelectionLayer selectionLayer, IUniqueIndexLayer upperLayer) {
        if (selectionLayer == null) {
            throw new IllegalArgumentException("SelectionLayer can not be null");
        }
        this.selectionLayer = selectionLayer;
        this.upperLayer = upperLayer;
    }

    @Override
    public boolean doCommand(ILayer layer, DeleteSelectionCommand command) {
        if (EditUtils.allCellsEditable(this.selectionLayer, this.upperLayer, command.getConfigRegistry())) {
            PositionCoordinate[] positionCoordinateArray = this.selectionLayer.getSelectedCellPositions();
            int n = positionCoordinateArray.length;
            int n2 = 0;
            while (n2 < n) {
                PositionCoordinate coord = positionCoordinateArray[n2];
                coord.getLayer().doCommand(new UpdateDataCommand(coord.getLayer(), coord.getColumnPosition(), coord.getRowPosition(), null));
                ++n2;
            }
        }
        return true;
    }

    @Override
    public Class<DeleteSelectionCommand> getCommandClass() {
        return DeleteSelectionCommand.class;
    }
}

