/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.editors;

import org.eclipse.fordiac.ide.ui.editors.DialogField;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectionButtonDialogField
extends DialogField {
    private Button fButton;
    private boolean fIsSelected = false;
    private DialogField[] fAttachedDialogFields = null;
    private final int fButtonStyle;

    public SelectionButtonDialogField(int buttonStyle) {
        this.fButtonStyle = buttonStyle;
    }

    public void attachDialogField(DialogField dialogField) {
        this.attachDialogFields(new DialogField[]{dialogField});
    }

    public void attachDialogFields(DialogField[] dialogFields) {
        this.fAttachedDialogFields = dialogFields;
        DialogField[] dialogFieldArray = dialogFields;
        int n = dialogFields.length;
        int n2 = 0;
        while (n2 < n) {
            DialogField dialogField = dialogFieldArray[n2];
            dialogField.setEnabled(this.fIsSelected);
            ++n2;
        }
    }

    public boolean isAttached(DialogField editor) {
        if (this.fAttachedDialogFields != null) {
            DialogField[] dialogFieldArray = this.fAttachedDialogFields;
            int n = this.fAttachedDialogFields.length;
            int n2 = 0;
            while (n2 < n) {
                DialogField dialogField = dialogFieldArray[n2];
                if (dialogField == editor) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Button button = this.getSelectionButton(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        gd.horizontalAlignment = 4;
        if (this.fButtonStyle == 8) {
            gd.widthHint = SelectionButtonDialogField.getButtonWidthHint(button);
        }
        button.setLayoutData((Object)gd);
        return new Control[]{button};
    }

    public Control[] doFillIntoGridWithoutMargin(Composite parent, int nColumns, boolean indent) {
        this.assertEnoughColumns(nColumns);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 0;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = nColumns;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)gd);
        GridData gridData = new GridData(4, 2, false, false);
        if (indent) {
            gridData.horizontalIndent = 20;
        }
        Button button = this.getSelectionButton(parent);
        button.setLayoutData((Object)gridData);
        return new Control[]{button};
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    public Button getSelectionButton(Composite group) {
        if (this.fButton == null) {
            this.assertCompositeNotNull(group);
            this.fButton = new Button(group, this.fButtonStyle);
            this.fButton.setFont(group.getFont());
            this.fButton.setText(this.fLabelText);
            this.fButton.setEnabled(this.isEnabled());
            this.fButton.setSelection(this.fIsSelected);
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected();
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected();
                }
            });
        }
        return this.fButton;
    }

    private void doWidgetSelected() {
        if (this.isOkToUse((Control)this.fButton)) {
            this.changeValue(this.fButton.getSelection());
        }
    }

    private void changeValue(boolean newState) {
        if (this.fIsSelected != newState) {
            this.fIsSelected = newState;
            if (this.fAttachedDialogFields != null) {
                boolean focusSet = false;
                DialogField[] dialogFieldArray = this.fAttachedDialogFields;
                int n = this.fAttachedDialogFields.length;
                int n2 = 0;
                while (n2 < n) {
                    DialogField dialogField = dialogFieldArray[n2];
                    dialogField.setEnabled(this.fIsSelected);
                    if (this.fIsSelected && !focusSet) {
                        focusSet = dialogField.setFocus();
                    }
                    ++n2;
                }
            }
            this.dialogFieldChanged();
        } else if (this.fButtonStyle == 8) {
            this.dialogFieldChanged();
        }
    }

    @Override
    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setText(labeltext);
        }
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    public void setSelection(boolean selected) {
        this.changeValue(selected);
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(selected);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(this.fIsSelected);
        }
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }
}

