/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.function.Consumer;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;

public class FBNetworkElementSetPositionCommand
extends SetPositionCommand
implements ConnectionLayoutTagger {
    private static final Consumer<IInterfaceElement> INPUT_CONSUMER = ie -> ie.getInputConnections().forEach(con -> con.getRoutingData().setNeedsValidation(true));
    private static final Consumer<IInterfaceElement> OUTPUT_CONSUMER = ie -> ie.getOutputConnections().forEach(con -> con.getRoutingData().setNeedsValidation(true));

    public FBNetworkElementSetPositionCommand(FBNetworkElement fbe, int dx, int dy) {
        super((PositionableElement)fbe, dx, dy);
    }

    public FBNetworkElement getPositionableElement() {
        return (FBNetworkElement)super.getPositionableElement();
    }

    @Override
    protected void setPosition(Position pos) {
        super.setPosition(pos);
        FBNetworkElement fBNetworkElement = this.getPositionableElement();
        if (fBNetworkElement instanceof BlockFBNetworkElement) {
            BlockFBNetworkElement bfbel = (BlockFBNetworkElement)fBNetworkElement;
            InterfaceList interfaceList = bfbel.getInterface();
            FBNetworkElementSetPositionCommand.invalidateInputConnections(interfaceList);
            FBNetworkElementSetPositionCommand.invalidateOutputConnections(interfaceList);
        }
    }

    private static void invalidateInputConnections(InterfaceList il) {
        il.getEventInputs().forEach(INPUT_CONSUMER);
        il.getInputVars().forEach(INPUT_CONSUMER);
        il.getSockets().forEach(INPUT_CONSUMER);
    }

    private static void invalidateOutputConnections(InterfaceList il) {
        il.getEventOutputs().forEach(OUTPUT_CONSUMER);
        il.getOutputVars().forEach(OUTPUT_CONSUMER);
        il.getPlugs().forEach(OUTPUT_CONSUMER);
    }
}

