/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.utilities.MarginBoundsHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class TrackerMarginBoundsHelper
extends MarginBoundsHelper {
    private static final int CORNER_RADIUS = 4;
    private static final int FIGURE_ALPHA = 100;
    private static Color fillColor = null;
    private EditPart currentTarget = null;
    private IFigure feedbackLayer;
    private List<? extends EditPart> selection;
    private final List<Figure> figureList = new ArrayList<Figure>();
    private final List<Figure> parentFigureList = Arrays.asList(new Figure[]{null});

    public static Color getFillColor() {
        if (fillColor == null) {
            fillColor = Display.getCurrent().getSystemColor(15);
        }
        return fillColor;
    }

    public void initDrag(EditPart sourceEP, List<? extends EditPart> selected) {
        super.updateMargins(sourceEP.getModel());
        this.feedbackLayer = LayerManager.Helper.find((EditPart)sourceEP).getLayer((Object)"Feedback Layer");
        this.selection = selected;
    }

    public List<Figure> getFigures() {
        return this.figureList;
    }

    public List<Figure> getParentFigure() {
        return this.parentFigureList;
    }

    public void createFigures(EditPart targetEditPart) {
        if (this.currentTarget != targetEditPart) {
            SubApp subApp;
            EObject eObject;
            AbstractFBNetworkEditPart networkEditPart;
            this.clearFigureList();
            this.currentTarget = targetEditPart;
            targetEditPart.getChildren().stream().filter(AbstractPositionableElementEditPart.class::isInstance).map(AbstractPositionableElementEditPart.class::cast).filter(Predicate.not(this.selection::contains)).forEach(ep -> {
                Rectangle bounds = ep.getFigure().getBounds().getCopy();
                if (!(ep.getModel() instanceof Comment)) {
                    this.expandRectangle(bounds);
                }
                RoundedRectangle figure = TrackerMarginBoundsHelper.createFigure(bounds, ep.getFigure().getForegroundColor());
                figure.validate();
                this.figureList.add((Figure)figure);
            });
            if (targetEditPart instanceof AbstractFBNetworkEditPart && (networkEditPart = (AbstractFBNetworkEditPart)targetEditPart).getModel() != null && (eObject = networkEditPart.getModel().eContainer()) instanceof SubApp && (subApp = (SubApp)eObject).isUnfolded()) {
                Rectangle bounds = networkEditPart.getFigure().getBounds().getCopy();
                Figure figureFigure = new Figure();
                figureFigure.setBounds(bounds);
                figureFigure.validate();
                this.parentFigureList.set(0, figureFigure);
            }
            this.figureList.forEach(arg_0 -> ((IFigure)this.feedbackLayer).add(arg_0));
        }
    }

    public void clearFigureList() {
        this.figureList.forEach(figure -> {
            if (this.feedbackLayer.getChildren().contains(figure)) {
                this.feedbackLayer.remove((IFigure)figure);
            }
        });
        this.figureList.clear();
        this.parentFigureList.set(0, null);
        this.currentTarget = null;
    }

    public static RoundedRectangle createFigure(Rectangle bounds, Color foregroundColor) {
        RoundedRectangle figure = new RoundedRectangle();
        figure.setBounds(bounds);
        figure.setOutline(false);
        figure.setAlpha(100);
        figure.setCornerDimensions(new Dimension(4, 4));
        figure.setForegroundColor(foregroundColor);
        figure.setBackgroundColor(TrackerMarginBoundsHelper.getFillColor());
        return figure;
    }
}

