/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.elk.FordiacLayoutMapping;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.gef.GraphicalEditPart;

public class FordiacGraphDataHelper {
    public static void calculate(FordiacLayoutMapping mapping) {
        mapping.getLayoutGraph().getChildren().forEach(child -> {
            GraphicalEditPart ep = (GraphicalEditPart)mapping.getGraphMap().get(child);
            if (ep != null) {
                Position pos = LibraryElementFactory.eINSTANCE.createPosition();
                pos.setX((double)((int)child.getX()));
                pos.setY((double)((int)child.getY()));
                mapping.getLayoutData().addPosition((FBNetworkElement)ep.getModel(), pos);
            }
        });
        mapping.getLayoutGraph().getContainedEdges().forEach(edge -> FordiacGraphDataHelper.processConnection(mapping, edge));
    }

    private static void processConnection(FordiacLayoutMapping mapping, ElkEdge edge) {
        if (edge.getSources().isEmpty() || edge.getTargets().isEmpty() || edge.getSections().isEmpty()) {
            return;
        }
        ConnectionEditPart connEp = (ConnectionEditPart)mapping.getGraphMap().get((Object)edge);
        ElkEdgeSection elkEdgeSection = (ElkEdgeSection)edge.getSections().get(0);
        mapping.getLayoutData().addConnectionPoints(connEp.getModel(), FordiacGraphDataHelper.createPointList(elkEdgeSection));
    }

    private static PointList createPointList(ElkEdgeSection elkEdgeSection) {
        PointList list = new PointList();
        list.addPoint((int)elkEdgeSection.getStartX(), (int)elkEdgeSection.getStartY());
        for (ElkBendPoint point : elkEdgeSection.getBendPoints()) {
            list.addPoint((int)point.getX(), (int)point.getY());
        }
        list.addPoint((int)elkEdgeSection.getEndX(), (int)elkEdgeSection.getEndY());
        return list;
    }

    private FordiacGraphDataHelper() {
    }
}

