/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.fordiac.ide.application.editparts.ContractCellEditor;
import org.eclipse.fordiac.ide.application.editparts.InstanceContract;
import org.eclipse.fordiac.ide.application.figures.InstanceContractFigure;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.TextDirectEditManager;
import org.eclipse.fordiac.ide.model.commands.change.ChangeContractCommand;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

public class InstanceContractEditPart
extends AbstractGraphicalEditPart {
    void refreshValue() {
        this.getFigure().setText(this.getModel().getContract());
    }

    public void refresh() {
        super.refresh();
        this.refreshValue();
    }

    public InstanceContractFigure getFigure() {
        return (InstanceContractFigure)super.getFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteContractEditPolicy());
        this.removeEditPolicy("DirectEditPolicy");
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ContractRenameEditPolicy());
    }

    public InstanceContract getModel() {
        return (InstanceContract)super.getModel();
    }

    protected IFigure createFigure() {
        return new InstanceContractFigure(this.getModel());
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    private void performDirectEdit() {
        new TextDirectEditManager((GraphicalEditPart)this, (CellEditorLocator)new FigureCellEditorLocator((IFigure)this.getFigure())){
            private boolean bringDownCalled;
            {
                this.bringDownCalled = false;
            }

            protected CellEditor createCellEditorOn(Composite composite) {
                return new ContractCellEditor(composite, InstanceContractEditPart.this.getModel());
            }

            protected void initCellEditor() {
                super.initCellEditor();
                this.getCellEditor().setValue((Object)InstanceContractEditPart.this.getModel().getContract());
            }

            protected void bringDown() {
                if (!this.bringDownCalled) {
                    this.bringDownCalled = true;
                    super.bringDown();
                }
            }
        }.show();
    }

    private class ContractRenameEditPolicy
    extends DirectEditPolicy {
        private ContractRenameEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            Object object = request.getCellEditor().getValue();
            if (object instanceof String) {
                String s = (String)object;
                return new ChangeContractCommand(InstanceContractEditPart.this.getModel().getSubApp(), s);
            }
            return null;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            String value = (String)request.getCellEditor().getValue();
            InstanceContractEditPart.this.getFigure().setText(value);
        }

        protected void revertOldEditValue(DirectEditRequest request) {
            InstanceContractEditPart.this.refreshValue();
        }
    }

    private class DeleteContractEditPolicy
    extends ComponentEditPolicy {
        private DeleteContractEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest request) {
            return new ChangeContractCommand(InstanceContractEditPart.this.getModel().getSubApp(), null);
        }
    }
}

