/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handles;

import java.util.List;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnection;
import org.eclipse.fordiac.ide.application.tools.FBNScrollingConnectionEndpointTracker;
import org.eclipse.fordiac.ide.application.tools.MultiFBNScrollingconnectionEndpointTracker;
import org.eclipse.fordiac.ide.gef.handles.ScrollingConnectionEndpointHandle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.tools.ConnectionEndpointTracker;

public class HiddenFBNConnectionEndPointHandle
extends ScrollingConnectionEndpointHandle {
    public HiddenFBNConnectionEndPointHandle(ConnectionEditPart owner, int endPoint) {
        super(owner, endPoint);
        Rectangle bounds = this.getLabelBounds().getExpanded(2, 2);
        this.setPreferredSize(bounds.width, bounds.height);
        this.setLocator((Locator)new ConnectionLocator(this.getConnection(), endPoint){

            protected Point getLocation(PointList points) {
                Point p = super.getLocation(points);
                switch (this.getAlignment()) {
                    case 2: {
                        p.x += HiddenFBNConnectionEndPointHandle.this.getPreferredSize().width / 2 - 2;
                        break;
                    }
                    case 3: {
                        p.x += -HiddenFBNConnectionEndPointHandle.this.getPreferredSize().width / 2 + 2;
                        break;
                    }
                }
                return p;
            }
        });
    }

    private Rectangle getLabelBounds() {
        FBNetworkConnection con = (FBNetworkConnection)this.getOwner().getFigure();
        if (this.getEndPoint() == 2) {
            return con.getSourceDecoration().getBounds();
        }
        return con.getTargetDecoration().getBounds();
    }

    protected void paintHandleCenter(Graphics g, Rectangle r) {
    }

    protected int getCornerRadius() {
        return 6;
    }

    protected ConnectionEndpointTracker createConnectionEndPointTracker(List<ConnectionEditPart> coSelectedConnections) {
        if (coSelectedConnections.size() > 1) {
            return new MultiFBNScrollingconnectionEndpointTracker(coSelectedConnections);
        }
        return new FBNScrollingConnectionEndpointTracker(coSelectedConnections.get(0));
    }
}

