/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editparts.TargetPinManager;
import org.eclipse.fordiac.ide.application.editparts.UntypedSubAppInterfaceElementEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;

public final class TargetInterfaceAdapter
extends AdapterImpl {
    private final UntypedSubAppInterfaceElementEditPart refEditPart;
    private final Set<EObject> secondaryTargets = new HashSet<EObject>();

    public TargetInterfaceAdapter(UntypedSubAppInterfaceElementEditPart refEditPart) {
        this.refEditPart = refEditPart;
        refEditPart.getModel().eAdapters().add((Object)this);
        this.refreshSecondaryTargets();
    }

    public void deactivate() {
        this.refEditPart.getModel().eAdapters().remove((Object)this);
        this.secondaryTargets.forEach(target -> {
            boolean bl = target.eAdapters().remove((Object)this);
        });
        this.secondaryTargets.clear();
    }

    public void notifyChanged(Notification notification) {
        if (this.refEditPart.getParent() != null && notification.getEventType() != 8) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getIInterfaceElement_InputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_OutputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getConnection_Destination().equals(feature) || LibraryElementPackage.eINSTANCE.getConnection_Source().equals(feature)) {
                this.refEditPart.refresh();
            }
            this.refreshSecondaryTargets();
        }
        super.notifyChanged(notification);
    }

    private void refreshSecondaryTargets() {
        Set<EObject> currentTargets = this.getCurrentTargets();
        this.secondaryTargets.removeIf(target -> {
            if (!currentTargets.contains(target)) {
                target.eAdapters().remove((Object)this);
                return true;
            }
            return false;
        });
        currentTargets.forEach(pin -> {
            if (this.secondaryTargets.add((EObject)pin)) {
                pin.eAdapters().add((Object)this);
            }
        });
    }

    private Set<EObject> getCurrentTargets() {
        IInterfaceElement model = this.refEditPart.getModel();
        HashSet<EObject> currTargets = new HashSet<EObject>();
        if (this.refEditPart.isInput()) {
            model.getInputConnections().forEach(srcCon -> TargetInterfaceAdapter.checkInputConns(currTargets, srcCon));
        } else {
            model.getOutputConnections().forEach(dstCon -> TargetInterfaceAdapter.checkoutOutputConns(currTargets, dstCon));
        }
        return currTargets;
    }

    private static void checkInputConns(Set<EObject> currTargets, Connection con) {
        currTargets.add((EObject)con);
        IInterfaceElement source = con.getSource();
        if (source != null) {
            currTargets.add((EObject)con.getSource());
            if (TargetPinManager.followConnections(source.getFBNetworkElement(), (EList<Connection>)source.getInputConnections())) {
                source.getInputConnections().forEach(srcCon -> TargetInterfaceAdapter.checkInputConns(currTargets, srcCon));
            }
        }
    }

    private static void checkoutOutputConns(Set<EObject> currTargets, Connection con) {
        currTargets.add((EObject)con);
        IInterfaceElement dest = con.getDestination();
        if (dest != null) {
            currTargets.add((EObject)dest);
            if (TargetPinManager.followConnections(dest.getFBNetworkElement(), (EList<Connection>)dest.getOutputConnections())) {
                dest.getOutputConnections().forEach(dstCon -> TargetInterfaceAdapter.checkoutOutputConns(currTargets, dstCon));
            } else {
                currTargets.addAll((Collection<EObject>)dest.getOutputConnections());
            }
        }
    }
}

