/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppCrossingConnectionsCommand;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkRootEditPart;
import org.eclipse.fordiac.ide.application.handlers.MarkPredecessorHandler;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorPart;

public class InsertFBIntoExecutionChainCommand
extends Command
implements ScopedCommand {
    private final SubApp subApp;
    private final FB insertedFB;
    private final IInterfaceElement predecessorOutputPin;
    private final CompoundCommand commands = new CompoundCommand();

    public InsertFBIntoExecutionChainCommand(SubApp subApp, FB insertedFB, FBNetworkRootEditPart rootEP) {
        this.subApp = subApp;
        this.insertedFB = insertedFB;
        this.predecessorOutputPin = this.getPredecessorEventOutput(MarkPredecessorHandler.getPredecessor(rootEP));
    }

    public boolean canExecute() {
        return this.subApp != null && this.insertedFB != null && this.predecessorOutputPin != null && !this.predecessorOutputPin.getOutputConnections().isEmpty();
    }

    public void execute() {
        if (this.insertedFB.getInterface() == null || this.insertedFB.getInterface().getEventInputs().isEmpty() || this.insertedFB.getInterface().getEventOutputs().isEmpty()) {
            return;
        }
        Optional<IInterfaceElement> inputInsertedFB = Optional.ofNullable((IInterfaceElement)this.insertedFB.getInterface().getEventInputs().getFirst());
        Optional<IInterfaceElement> outputInsertedFB = Optional.ofNullable((IInterfaceElement)this.insertedFB.getInterface().getEventOutputs().getFirst());
        if (inputInsertedFB.isEmpty() || outputInsertedFB.isEmpty()) {
            return;
        }
        this.commands.add(InsertFBIntoExecutionChainCommand.getCreateConnectionCommand(this.insertedFB.getFbNetwork(), this.predecessorOutputPin, inputInsertedFB.get()));
        this.commands.add(InsertFBIntoExecutionChainCommand.getCreateConnectionCommand(this.insertedFB.getFbNetwork(), outputInsertedFB.get(), ((Connection)this.predecessorOutputPin.getOutputConnections().getFirst()).getDestination()));
        this.commands.add((Command)new DeleteConnectionCommand((Connection)this.predecessorOutputPin.getOutputConnections().getFirst()));
        this.commands.add((Command)new SetPredecessorCommand(InsertFBIntoExecutionChainCommand.getEP((FBNetworkElement)this.insertedFB)));
        if (this.commands.canExecute()) {
            this.commands.execute();
        }
    }

    public void undo() {
        this.commands.undo();
    }

    public void redo() {
        this.commands.redo();
    }

    public Set<EObject> getAffectedObjects() {
        return this.commands.getCommands().stream().filter(ScopedCommand.class::isInstance).map(obj -> ((ScopedCommand)obj).getAffectedObjects()).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    private static Command getCreateConnectionCommand(FBNetwork network, IInterfaceElement source, IInterfaceElement target) {
        if (source.getFBNetworkElement().getFbNetwork() != target.getFBNetworkElement().getFbNetwork()) {
            return CreateSubAppCrossingConnectionsCommand.createProcessBorderCrossingConnection(source, target);
        }
        AbstractConnectionCreateCommand createConnectionCommand = AbstractConnectionCreateCommand.createCommand((FBNetwork)network, (IInterfaceElement)source, (IInterfaceElement)target);
        createConnectionCommand.setSource(source);
        createConnectionCommand.setDestination(target);
        return createConnectionCommand;
    }

    private IInterfaceElement getPredecessorEventOutput(AbstractFBNElementEditPart predecessor) {
        if (predecessor == null) {
            return this.getExecutionChainEnd();
        }
        if (!predecessor.getModel().getInterface().getEventOutputs().isEmpty()) {
            return (IInterfaceElement)predecessor.getModel().getInterface().getEventOutputs().getFirst();
        }
        return null;
    }

    private IInterfaceElement getExecutionChainEnd() {
        Optional<IInterfaceElement> saEventOutput = this.subApp.getInterface().getOutputs().filter(ie -> !ie.getInputConnections().isEmpty()).findFirst();
        if (saEventOutput.isPresent() && !saEventOutput.get().getInputConnections().isEmpty()) {
            return ((Connection)saEventOutput.get().getInputConnections().getFirst()).getSource();
        }
        return null;
    }

    private static AbstractFBNElementEditPart getEP(FBNetworkElement elem) {
        GraphicalViewer viewer;
        EditPart editPart;
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null && (editPart = (EditPart)(viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class)).getEditPartRegistry().get(elem)) instanceof AbstractFBNElementEditPart) {
            AbstractFBNElementEditPart ep = (AbstractFBNElementEditPart)editPart;
            return ep;
        }
        return null;
    }

    public class SetPredecessorCommand
    extends Command {
        private AbstractFBNElementEditPart predecessor;
        private AbstractFBNElementEditPart oldPredecessor;

        public SetPredecessorCommand(AbstractFBNElementEditPart predecessor) {
            this.predecessor = predecessor;
        }

        public boolean canExecute() {
            return this.predecessor != null;
        }

        public void execute() {
            RootEditPart rootEditPart = this.predecessor.getRoot();
            if (rootEditPart instanceof FBNetworkRootEditPart) {
                FBNetworkRootEditPart root = (FBNetworkRootEditPart)rootEditPart;
                this.oldPredecessor = MarkPredecessorHandler.getPredecessor(root);
                if (this.oldPredecessor != null) {
                    MarkPredecessorHandler.setPredecessor(root, this.predecessor);
                }
            }
        }

        public void undo() {
            RootEditPart rootEditPart;
            if (this.predecessor != null && (rootEditPart = this.predecessor.getRoot()) instanceof FBNetworkRootEditPart) {
                FBNetworkRootEditPart root = (FBNetworkRootEditPart)rootEditPart;
                this.predecessor = MarkPredecessorHandler.getPredecessor(root);
                MarkPredecessorHandler.setPredecessor(root, this.oldPredecessor);
            }
        }

        public void redo() {
            this.execute();
        }
    }
}

