/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort.painter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class SortIconPainter
extends ImagePainter {
    private List<Image> upImages = new ArrayList<Image>();
    private List<Image> downImages = new ArrayList<Image>();

    public SortIconPainter() {
        this(true);
    }

    public SortIconPainter(boolean paintBg) {
        this(paintBg, false);
    }

    public SortIconPainter(boolean paintBg, boolean invertIcons) {
        super(null, paintBg);
        String postFix = "";
        if (invertIcons) {
            postFix = "_inv";
        }
        this.upImages.add(GUIHelper.getImage("up_0" + postFix));
        this.upImages.add(GUIHelper.getImage("up_1" + postFix));
        this.upImages.add(GUIHelper.getImage("up_2" + postFix));
        this.downImages.add(GUIHelper.getImage("down_0" + postFix));
        this.downImages.add(GUIHelper.getImage("down_1" + postFix));
        this.downImages.add(GUIHelper.getImage("down_2" + postFix));
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        Image icon = null;
        if (this.isSortedAscending(cell)) {
            icon = this.selectUpImage(this.getSortSequence(cell));
        } else if (this.isSortedDescending(cell)) {
            icon = this.selectDownImage(this.getSortSequence(cell));
        }
        return icon;
    }

    private boolean isSortedAscending(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("SORT_UP");
    }

    private boolean isSortedDescending(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("SORT_DOWN");
    }

    private int getSortSequence(ILayerCell cell) {
        int sortSeq = 0;
        for (String configLabel : cell.getConfigLabels()) {
            if (!configLabel.startsWith("SORT_SEQ_")) continue;
            String[] tokens = configLabel.split("_");
            sortSeq = Integer.parseInt(tokens[tokens.length - 1]);
        }
        return sortSeq;
    }

    protected Image selectUpImage(int sortSequence) {
        return sortSequence < this.upImages.size() ? this.upImages.get(sortSequence) : this.upImages.get(this.upImages.size() - 1);
    }

    protected Image selectDownImage(int sortSequence) {
        return sortSequence < this.downImages.size() ? this.downImages.get(sortSequence) : this.downImages.get(this.downImages.size() - 1);
    }

    public void setSortImages(Image upImage0, Image upImage1, Image upImage2, Image downImage0, Image downImage1, Image downImage2) {
        this.upImages.clear();
        this.upImages.add(upImage0);
        this.upImages.add(upImage1);
        this.upImages.add(upImage2);
        this.downImages.clear();
        this.downImages.add(downImage0);
        this.downImages.add(downImage1);
        this.downImages.add(downImage2);
    }

    public void setSortImages(List<Image> upImages, List<Image> downImages) {
        this.upImages = upImages;
        this.downImages = downImages;
    }
}

