/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextfunctioneditor.util;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STFunction;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.util.STAbstractCorePartitioner;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.fordiac.ide.structuredtextcore.util.STRecoveringPartitioner;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.services.STFunctionGrammarAccess;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.util.STFunctionPartition;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class STFunctionPartitioner
extends STRecoveringPartitioner<STFunction> {
    @Inject
    private STFunctionGrammarAccess grammarAccess;

    public String combine(LibraryElement libraryElement) {
        if (libraryElement instanceof FunctionFBType) {
            FunctionFBType functionFbType = (FunctionFBType)libraryElement;
            return STFunctionPartitioner.combine(functionFbType);
        }
        return "";
    }

    protected static String combine(FunctionFBType fbType) {
        STFunctionBody stBody;
        FunctionBody functionBody = fbType.getBody();
        if (functionBody instanceof STFunctionBody && (stBody = (STFunctionBody)functionBody).getText() != null) {
            return stBody.getText();
        }
        return STFunctionPartitioner.generateFunctionText(fbType);
    }

    protected static String generateFunctionText(FunctionFBType fbType) {
        StringBuilder builder = new StringBuilder();
        STFunctionPartitioner.generatePackage((LibraryElement)fbType, (StringBuilder)builder);
        STFunctionPartitioner.generateImports((LibraryElement)fbType, (StringBuilder)builder);
        builder.append("FUNCTION ");
        builder.append(fbType.getName());
        DataType returnType = fbType.getReturnType();
        if (returnType != null) {
            builder.append(" : ");
            builder.append(returnType.getName());
        }
        builder.append("\n");
        STFunctionPartitioner.generateFunctionParameters("INPUT", (List<? extends INamedElement>)fbType.getInputParameters(), builder);
        STFunctionPartitioner.generateFunctionParameters("IN_OUT", (List<? extends INamedElement>)fbType.getInOutParameters(), builder);
        STFunctionPartitioner.generateFunctionParameters("OUTPUT", (List<? extends INamedElement>)fbType.getOutputParameters(), builder);
        builder.append("END_FUNCTION");
        builder.append("\n");
        builder.append("\n");
        return builder.toString();
    }

    protected static void generateFunctionParameters(String type, List<? extends INamedElement> parameters, StringBuilder builder) {
        if (parameters.isEmpty()) {
            return;
        }
        builder.append("VAR_");
        builder.append(type);
        builder.append("\n");
        parameters.stream().filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast).forEach(param -> {
            builder.append("    ");
            STFunctionPartitioner.generateVariable((VarDeclaration)param, (StringBuilder)builder);
            builder.append("\n");
        });
        builder.append("END_VAR");
        builder.append("\n");
    }

    public Optional<STCorePartition> partition(XtextResource resource) {
        if (resource.getEntryPoint() != null && resource.getEntryPoint() != this.grammarAccess.getSTFunctionSourceRule()) {
            return Optional.empty();
        }
        EObject source = (EObject)resource.getContents().get(0);
        if (source instanceof STFunctionSource) {
            STFunctionSource functionSource = (STFunctionSource)source;
            return this.partition(functionSource);
        }
        return this.emergencyPartition(resource);
    }

    protected Optional<STCorePartition> partition(STFunctionSource source) {
        try {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)source);
            List<Import> imports = source.getImports().stream().map(STAbstractCorePartitioner::convertImport).filter(Objects::nonNull).toList();
            ArrayList callables = source.getFunctions().stream().map(this::convertSourceElement).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
            this.handleLostAndFound(node.getRootNode(), (List)source.getFunctions(), callables);
            return Optional.of(new STFunctionPartition(source.getName(), imports, node.getText(), callables));
        }
        catch (Exception e) {
            return this.emergencyPartition((STSource)source);
        }
    }

    protected STFunction convertSourceElement(org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction function) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)function);
        if (node == null || function.getName() == null) {
            return null;
        }
        STFunction result = LibraryElementFactory.eINSTANCE.createSTFunction();
        result.setName(function.getName());
        String comment = this.getDocumentationProvider().getDocumentation((EObject)function);
        if (comment != null) {
            result.setComment(comment);
        }
        function.getInputParameters().stream().map(STVarDeclaration.class::cast).filter(STAbstractCorePartitioner::isValidParameter).map(arg_0 -> ((STFunctionPartitioner)this).convertInputParameter(arg_0)).forEachOrdered(arg_0 -> result.getInputParameters().add(arg_0));
        function.getOutputParameters().stream().map(STVarDeclaration.class::cast).filter(STAbstractCorePartitioner::isValidParameter).map(arg_0 -> ((STFunctionPartitioner)this).convertOutputParameter(arg_0)).forEachOrdered(arg_0 -> result.getOutputParameters().add(arg_0));
        function.getInOutParameters().stream().map(STVarDeclaration.class::cast).filter(STAbstractCorePartitioner::isValidParameter).map(arg_0 -> ((STFunctionPartitioner)this).convertInOutParameter(arg_0)).forEachOrdered(arg_0 -> result.getInOutParameters().add(arg_0));
        result.setReturnType(STFunctionPartitioner.resolveDataType((LibraryElement)function.getReturnType(), (EObject)function, null));
        result.setText(node.getText());
        return result;
    }

    protected STCorePartition createEmergencyPartition(String originalSource) {
        return new STFunctionPartition(null, Collections.emptyList(), originalSource, List.of(this.createLostAndFound(originalSource, 0)));
    }

    protected STFunction createLostAndFound(String text, int index) {
        STFunction function = LibraryElementFactory.eINSTANCE.createSTFunction();
        function.setName(STFunctionPartitioner.generateLostAndFoundName((int)index));
        function.setComment(STFunctionPartitioner.generateLostAndFoundComment((int)index));
        function.setText(text);
        return function;
    }

    protected void appendText(STFunction function, String text) {
        function.setText(function.getText() + text);
    }
}

