/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.emf;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.util.ITransformer;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class HashMetaData {
    public static final String ANNOTATION_URI = "http:///org/eclipse/fordiac/ide/model/HashMetaData";
    public static final String IGNORED_KEY = "ignored";
    public static final String TRANSFORMER_KEY = "transformer";

    public static boolean isIgnored(EModelElement element) {
        if (element == null) {
            return false;
        }
        String annotation = EcoreUtil.getAnnotation((EModelElement)element, (String)ANNOTATION_URI, (String)IGNORED_KEY);
        return annotation != null && Boolean.parseBoolean(annotation);
    }

    public static Object transform(EModelElement element, Object value) {
        if (element == null) {
            return value;
        }
        String annotation = EcoreUtil.getAnnotation((EModelElement)element, (String)ANNOTATION_URI, (String)TRANSFORMER_KEY);
        if (annotation == null) {
            return value;
        }
        try {
            Object obj = Class.forName(annotation).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof ITransformer) {
                ITransformer itransformer = (ITransformer)obj;
                return itransformer.transform(value);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            FordiacLogHelper.logError((String)"Could not transform model element!", (Throwable)e);
        }
        return value;
    }

    private HashMetaData() {
        throw new UnsupportedOperationException();
    }
}

