/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ErrorTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public final class BlockInstanceFactory {
    public static BlockFBNetworkElement createBlockInstanceForTypeEntry(TypeEntry entry) {
        if (entry == null) {
            return LibraryElementFactory.eINSTANCE.createErrorMarkerFBNElement();
        }
        if (entry instanceof SubAppTypeEntry) {
            return LibraryElementFactory.eINSTANCE.createTypedSubApp();
        }
        if (entry instanceof AdapterTypeEntry) {
            return LibraryElementFactory.eINSTANCE.createAdapterFB();
        }
        if (entry instanceof FBTypeEntry) {
            FBTypeEntry fbEntry = (FBTypeEntry)entry;
            return BlockInstanceFactory.createFBInstanceForTypeEntry(fbEntry);
        }
        return null;
    }

    public static FB createFBInstanceForTypeEntry(FBTypeEntry entry) {
        if (entry instanceof ErrorTypeEntry) {
            return LibraryElementFactory.eINSTANCE.createFB();
        }
        if (entry.getTypeName().startsWith("COMM_MESSAGE")) {
            return LibraryElementFactory.eINSTANCE.createCommunicationChannel();
        }
        if ("STRUCT_MUX".equals(entry.getTypeName()) && BlockInstanceFactory.matchesPackageName(entry, "eclipse4diac::convert")) {
            return LibraryElementFactory.eINSTANCE.createMultiplexer();
        }
        if ("STRUCT_DEMUX".equals(entry.getTypeName()) && BlockInstanceFactory.matchesPackageName(entry, "eclipse4diac::convert")) {
            return LibraryElementFactory.eINSTANCE.createDemultiplexer();
        }
        if ("F_MOVE".equals(entry.getTypeName()) && BlockInstanceFactory.matchesPackageName(entry, "iec61131::selection")) {
            return LibraryElementFactory.eINSTANCE.createConfigurableMoveFB();
        }
        if (LibraryElementPackage.Literals.COMPOSITE_FB_TYPE.equals(entry.getTypeEClass())) {
            return LibraryElementFactory.eINSTANCE.createCFBInstance();
        }
        return LibraryElementFactory.eINSTANCE.createFB();
    }

    private static boolean matchesPackageName(TypeEntry entry, String packageName) {
        return entry.getPackageName().isEmpty() || entry.getPackageName().equals(packageName);
    }

    private BlockInstanceFactory() {
        throw new UnsupportedOperationException();
    }
}

