/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.command.AbstractMultiColumnCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class MultiColumnResizeCommand
extends AbstractMultiColumnCommand {
    private int commonColumnWidth = -1;
    protected Map<ColumnPositionCoordinate, Integer> colPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>();
    private final boolean downScale;

    public MultiColumnResizeCommand(ILayer layer, int[] columnPositions, int commonColumnWidth) {
        this(layer, columnPositions, commonColumnWidth, false);
    }

    public MultiColumnResizeCommand(ILayer layer, int[] columnPositions, int commonColumnWidth, boolean downScale) {
        super(layer, columnPositions);
        this.commonColumnWidth = commonColumnWidth;
        this.downScale = downScale;
    }

    public MultiColumnResizeCommand(ILayer layer, int[] columnPositions, int[] columnWidths) {
        this(layer, columnPositions, columnWidths, false);
    }

    public MultiColumnResizeCommand(ILayer layer, int[] columnPositions, int[] columnWidths, boolean downScale) {
        super(layer, columnPositions);
        int i = 0;
        while (i < columnPositions.length) {
            this.colPositionToWidth.put(new ColumnPositionCoordinate(layer, columnPositions[i]), columnWidths[i]);
            ++i;
        }
        this.downScale = downScale;
    }

    protected MultiColumnResizeCommand(MultiColumnResizeCommand command) {
        super(command);
        this.commonColumnWidth = command.commonColumnWidth;
        this.colPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>(command.colPositionToWidth);
        this.downScale = command.downScale;
    }

    public int getCommonColumnWidth() {
        return this.commonColumnWidth;
    }

    public int getColumnWidth(int columnPosition) {
        for (ColumnPositionCoordinate columnPositionCoordinate : this.colPositionToWidth.keySet()) {
            if (columnPositionCoordinate.getColumnPosition() != columnPosition) continue;
            return this.colPositionToWidth.get(columnPositionCoordinate);
        }
        return this.commonColumnWidth;
    }

    public boolean downScaleValue() {
        return this.downScale;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        HashMap<ColumnPositionCoordinate, Integer> newColPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>();
        for (ColumnPositionCoordinate columnPositionCoordinate : this.colPositionToWidth.keySet()) {
            ColumnPositionCoordinate convertedColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(columnPositionCoordinate, targetLayer);
            if (convertedColumnPositionCoordinate == null) continue;
            newColPositionToWidth.put(convertedColumnPositionCoordinate, this.colPositionToWidth.get(columnPositionCoordinate));
        }
        if (super.convertToTargetLayer(targetLayer)) {
            this.colPositionToWidth = newColPositionToWidth;
            return true;
        }
        return false;
    }

    @Override
    public MultiColumnResizeCommand cloneCommand() {
        return new MultiColumnResizeCommand(this);
    }
}

