/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridFooterRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DefaultColumnFooterRenderer
extends GridFooterRenderer {
    int leftMargin = 6;
    int rightMargin = 6;
    int topMargin = 3;
    int bottomMargin = 3;
    int arrowMargin = 6;
    int imageSpacing = 3;

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        GridColumn column = (GridColumn)((Object)value);
        gc.setFont(column.getFooterFont());
        int x = 0;
        x += this.leftMargin;
        x += gc.stringExtent((String)column.getText()).x + this.rightMargin;
        int y = 0;
        y += this.topMargin;
        y += gc.getFontMetrics().getHeight();
        y += this.bottomMargin;
        if (column.getFooterImage() != null) {
            x += column.getFooterImage().getBounds().width + this.imageSpacing;
            y = Math.max(y, this.topMargin + column.getFooterImage().getBounds().height + this.bottomMargin);
        }
        return new Point(x, y);
    }

    @Override
    public void paint(GC gc, Object value) {
        int len;
        GridColumn column = (GridColumn)((Object)value);
        gc.setFont(column.getFooterFont());
        gc.setBackground(this.getDisplay().getSystemColor(22));
        gc.setForeground(this.getDisplay().getSystemColor(21));
        gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x + this.getBounds().width, this.getBounds().y);
        int x = this.leftMargin;
        if (column.getFooterImage() != null) {
            gc.drawImage(column.getFooterImage(), this.getBounds().x + x, this.getBounds().y + this.getBounds().height - this.bottomMargin - column.getFooterImage().getBounds().height);
            x += column.getFooterImage().getBounds().width + this.imageSpacing;
        }
        int width = this.getBounds().width - x;
        if (column.getSort() == 0) {
            width -= this.rightMargin;
        }
        gc.setForeground(this.getDisplay().getSystemColor(21));
        int y = this.getBounds().y + this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight();
        String text = TextUtils.getShortStr(gc, column.getFooterText(), width, this.truncationStyle);
        if (column.getAlignment() == 131072) {
            int len2 = gc.stringExtent((String)text).x;
            if (len2 < width) {
                x += width - len2;
            }
        } else if (column.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        gc.drawString(text, this.getBounds().x + x, y, true);
    }

    @Override
    public boolean notify(int event, Point point, Object value) {
        return false;
    }

    @Override
    public Rectangle getTextBounds(Object value, boolean preferred) {
        GridColumn column = (GridColumn)((Object)value);
        int x = this.leftMargin;
        if (column.getImage() != null) {
            x += column.getImage().getBounds().width + this.imageSpacing;
        }
        GC gc = new GC((Drawable)column.getParent());
        gc.setFont(column.getFooterFont());
        int y = this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight();
        Rectangle bounds = new Rectangle(x, y, 0, 0);
        Point p = gc.stringExtent(column.getText());
        bounds.height = p.y;
        if (preferred) {
            bounds.width = p.x;
        } else {
            int width = this.getBounds().width - x;
            if (column.getSort() == 0) {
                width -= this.rightMargin;
            }
            bounds.width = width;
        }
        gc.dispose();
        return bounds;
    }
}

