/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryReadValueId
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=635");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=637");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=636");
    private final NodeId nodeId;
    private final String indexRange;
    private final QualifiedName dataEncoding;
    private final ByteString continuationPoint;

    public HistoryReadValueId(NodeId nodeId, String indexRange, QualifiedName dataEncoding, ByteString continuationPoint) {
        this.nodeId = nodeId;
        this.indexRange = indexRange;
        this.dataEncoding = dataEncoding;
        this.continuationPoint = continuationPoint;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public QualifiedName getDataEncoding() {
        return this.dataEncoding;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    protected HistoryReadValueId(HistoryReadValueIdBuilder<?, ?> b) {
        super(b);
        this.nodeId = ((HistoryReadValueIdBuilder)b).nodeId;
        this.indexRange = ((HistoryReadValueIdBuilder)b).indexRange;
        this.dataEncoding = ((HistoryReadValueIdBuilder)b).dataEncoding;
        this.continuationPoint = ((HistoryReadValueIdBuilder)b).continuationPoint;
    }

    public static HistoryReadValueIdBuilder<?, ?> builder() {
        return new HistoryReadValueIdBuilderImpl();
    }

    public HistoryReadValueIdBuilder<?, ?> toBuilder() {
        return new HistoryReadValueIdBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryReadValueId)) {
            return false;
        }
        HistoryReadValueId other = (HistoryReadValueId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$nodeId = this.getNodeId();
        NodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        String this$indexRange = this.getIndexRange();
        String other$indexRange = other.getIndexRange();
        if (this$indexRange == null ? other$indexRange != null : !this$indexRange.equals(other$indexRange)) {
            return false;
        }
        QualifiedName this$dataEncoding = this.getDataEncoding();
        QualifiedName other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !((Object)this$dataEncoding).equals(other$dataEncoding)) {
            return false;
        }
        ByteString this$continuationPoint = this.getContinuationPoint();
        ByteString other$continuationPoint = other.getContinuationPoint();
        return !(this$continuationPoint == null ? other$continuationPoint != null : !((Object)this$continuationPoint).equals(other$continuationPoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryReadValueId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        String $indexRange = this.getIndexRange();
        result = result * 59 + ($indexRange == null ? 43 : $indexRange.hashCode());
        QualifiedName $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : ((Object)$dataEncoding).hashCode());
        ByteString $continuationPoint = this.getContinuationPoint();
        result = result * 59 + ($continuationPoint == null ? 43 : ((Object)$continuationPoint).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryReadValueId(nodeId=" + this.getNodeId() + ", indexRange=" + this.getIndexRange() + ", dataEncoding=" + this.getDataEncoding() + ", continuationPoint=" + this.getContinuationPoint() + ")";
    }

    private static final class HistoryReadValueIdBuilderImpl
    extends HistoryReadValueIdBuilder<HistoryReadValueId, HistoryReadValueIdBuilderImpl> {
        private HistoryReadValueIdBuilderImpl() {
        }

        @Override
        protected HistoryReadValueIdBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryReadValueId build() {
            return new HistoryReadValueId(this);
        }
    }

    public static abstract class HistoryReadValueIdBuilder<C extends HistoryReadValueId, B extends HistoryReadValueIdBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId nodeId;
        private String indexRange;
        private QualifiedName dataEncoding;
        private ByteString continuationPoint;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryReadValueIdBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryReadValueId instance, HistoryReadValueIdBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.indexRange(instance.indexRange);
            b.dataEncoding(instance.dataEncoding);
            b.continuationPoint(instance.continuationPoint);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B indexRange(String indexRange) {
            this.indexRange = indexRange;
            return (B)this.self();
        }

        public B dataEncoding(QualifiedName dataEncoding) {
            this.dataEncoding = dataEncoding;
            return (B)this.self();
        }

        public B continuationPoint(ByteString continuationPoint) {
            this.continuationPoint = continuationPoint;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryReadValueId.HistoryReadValueIdBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", indexRange=" + this.indexRange + ", dataEncoding=" + this.dataEncoding + ", continuationPoint=" + this.continuationPoint + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryReadValueId> {
        @Override
        public Class<HistoryReadValueId> getType() {
            return HistoryReadValueId.class;
        }

        @Override
        public HistoryReadValueId decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            String indexRange = decoder.readString("IndexRange");
            QualifiedName dataEncoding = decoder.readQualifiedName("DataEncoding");
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            return new HistoryReadValueId(nodeId, indexRange, dataEncoding, continuationPoint);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryReadValueId value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeString("IndexRange", value.getIndexRange());
            encoder.writeQualifiedName("DataEncoding", value.getDataEncoding());
            encoder.writeByteString("ContinuationPoint", value.getContinuationPoint());
        }
    }
}

