/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class SeeAlsoPart
extends AbstractFormPart
implements IHelpPart {
    private final Composite container;
    private final Composite linkContainer;
    private ReusableHelpPart helpPart;
    private String id;
    private Image bgImage;
    private final HyperlinkGroup hyperlinkGroup;

    public SeeAlsoPart(Composite parent, FormToolkit toolkit) {
        this.container = toolkit.createComposite(parent);
        this.container.setBackgroundMode(1);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginTop = 2;
        this.container.setLayout((Layout)layout);
        this.linkContainer = new Composite(this.container, 0);
        this.linkContainer.setLayoutData((Object)new GridData(1808));
        RowLayout rlayout = new RowLayout();
        rlayout.marginBottom = 0;
        rlayout.marginTop = 0;
        rlayout.marginLeft = 0;
        rlayout.marginRight = 0;
        rlayout.justify = false;
        rlayout.wrap = true;
        this.linkContainer.setLayout((Layout)rlayout);
        this.hyperlinkGroup = new HyperlinkGroup(this.container.getDisplay());
        this.hyperlinkGroup.setHyperlinkUnderlineMode(toolkit.getHyperlinkGroup().getHyperlinkUnderlineMode());
    }

    private void updateLinks(String href) {
        Control[] children = this.linkContainer.getChildren();
        int i = 0;
        while (i < children.length) {
            ImageHyperlink link = (ImageHyperlink)children[i];
            RowData data = (RowData)link.getLayoutData();
            boolean isCurrentPage = link.getHref().equals(href);
            if (isCurrentPage) {
                link.setFont(JFaceResources.getBannerFont());
            } else {
                link.setFont(JFaceResources.getDefaultFont());
            }
            data.exclude = false;
            link.setVisible(!data.exclude);
            ++i;
        }
        this.linkContainer.layout();
        this.helpPart.reflow();
    }

    private void addLinks(final Composite container, FormToolkit toolkit) {
        HyperlinkAdapter listener = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                container.getDisplay().asyncExec(() -> {
                    ReusableHelpPart.HelpPartPage helpPartPage = SeeAlsoPart.this.helpPart.showPage((String)e.getHref(), true);
                });
            }
        };
        if ((this.helpPart.getStyle() & 2) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_allTopics, "all-topics-page", "etool16/alltopics_co.png", (IHyperlinkListener)listener);
        }
        if ((this.helpPart.getStyle() & 8) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_search, "fsearch-page", "etool16/helpsearch_co.png", (IHyperlinkListener)listener);
        }
        if ((this.helpPart.getStyle() & 4) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_contextHelp, "context-help-page", "etool16/reltopics_co.png", (IHyperlinkListener)listener);
        }
        if ((this.helpPart.getStyle() & 0x10) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_bookmarks, "bookmarks-page", "obj16/bookmarks_view.png", (IHyperlinkListener)listener);
        }
        if ((this.helpPart.getStyle() & 0x20) != 0) {
            this.addPageLink(container, toolkit, Messages.SeeAlsoPart_index, "index-page", "etool16/index_co.png", (IHyperlinkListener)listener);
        }
    }

    private void addPageLink(Composite container, FormToolkit toolkit, String text, String id, String imgRef, IHyperlinkListener listener) {
        String cid = this.helpPart.getCurrentPageId();
        if (cid != null && cid.equals(id)) {
            return;
        }
        ImageHyperlink link = new ImageHyperlink(container, 0x40 | toolkit.getOrientation());
        toolkit.adapt((Control)link, true, true);
        link.setImage(HelpUIResources.getImage(imgRef));
        link.setText(text);
        link.setHref((Object)id);
        link.setBackground(null);
        link.addHyperlinkListener(listener);
        this.hyperlinkGroup.add((Hyperlink)link);
        RowData data = new RowData();
        data.exclude = false;
        link.setLayoutData((Object)data);
    }

    @Override
    public Control getControl() {
        return this.container;
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        this.helpPart = parent;
        this.id = id;
        FormToolkit toolkit = this.helpPart.getForm().getToolkit();
        this.addLinks(this.linkContainer, toolkit);
        Composite padding = toolkit.createComposite(this.container);
        GridData paddingData = new GridData(256);
        paddingData.heightHint = 2;
        padding.setLayoutData((Object)paddingData);
        Composite separator = new Composite(this.container, 0);
        GridData seperatorData = new GridData(256);
        separator.setBackground(toolkit.getColors().getBorderColor());
        seperatorData.heightHint = 1;
        separator.setLayoutData((Object)seperatorData);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        this.container.setVisible(visible);
        if (visible) {
            this.markStale();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.bgImage != null && !this.bgImage.isDisposed()) {
            this.bgImage.dispose();
        }
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        return false;
    }

    @Override
    public boolean hasFocusControl(Control control) {
        return control != null && control.getParent() == this.linkContainer;
    }

    @Override
    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.COPY.getId())) {
            return this.helpPart.getCopyAction();
        }
        return null;
    }

    @Override
    public void stop() {
    }

    public void refresh() {
        if (this.linkContainer != null && this.helpPart.getCurrentPageId() != null) {
            this.updateLinks(this.helpPart.getCurrentPageId());
        }
        super.refresh();
    }

    @Override
    public void toggleRoleFilter() {
    }

    @Override
    public void refilter() {
    }

    @Override
    public void saveState(IMemento memento) {
    }

    public void setFocus() {
        if (this.linkContainer != null) {
            this.linkContainer.setFocus();
        }
    }
}

