/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.outline;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.ui.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.ui.outline.OutlineHeadingNode;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.util.ITextRegion;

public class STCoreOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    private static final Pattern HEADING_PATTERN = Pattern.compile("//\\s*\\$h(\\d+)\\s+(.+)\\R");

    protected boolean _isLeaf(STVarDeclaration modelElement) {
        return true;
    }

    protected void _createChildren(IOutlineNode parentNode, STVarDeclaration modelElement) {
    }

    protected static boolean hasHeadings(EObject modelElement) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)modelElement);
        if (node != null) {
            return STCoreOutlineTreeProvider.hasHeadings(node);
        }
        return false;
    }

    protected static boolean hasHeadings(ICompositeNode node) {
        for (ILeafNode leaf : node.getLeafNodes()) {
            if (!STCoreOutlineTreeProvider.isSingleLineComment(leaf) || !HEADING_PATTERN.matcher(leaf.getText()).matches()) continue;
            return true;
        }
        return false;
    }

    protected static void createHeadingNodes(IOutlineNode parentNode, EObject modelElement) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)modelElement);
        if (node != null) {
            STCoreOutlineTreeProvider.createHeadingNodes(parentNode, node);
        }
    }

    protected static void createHeadingNodes(IOutlineNode parentNode, ICompositeNode node) {
        for (ILeafNode leaf : node.getLeafNodes()) {
            Matcher matcher;
            if (!STCoreOutlineTreeProvider.isSingleLineComment(leaf) || !(matcher = HEADING_PATTERN.matcher(leaf.getText())).matches()) continue;
            int level = Integer.parseInt(matcher.group(1));
            String text = matcher.group(2);
            parentNode = STCoreOutlineTreeProvider.findHeadingParent(parentNode, level);
            parentNode = STCoreOutlineTreeProvider.createHeadingNode(parentNode, level, text, leaf.getTextRegion());
        }
    }

    protected static IOutlineNode findHeadingParent(IOutlineNode parentNode, int level) {
        while (STCoreOutlineTreeProvider.getLevel(parentNode) >= level) {
            parentNode = parentNode.getParent();
        }
        while (STCoreOutlineTreeProvider.getLevel(parentNode) < level - 1) {
            parentNode = STCoreOutlineTreeProvider.createHeadingNode(parentNode, STCoreOutlineTreeProvider.getLevel(parentNode) + 1, Messages.STCoreOutlineTreeProvider_MissingHeadingText, null);
        }
        return parentNode;
    }

    protected static OutlineHeadingNode createHeadingNode(IOutlineNode parentNode, int level, String text, ITextRegion region) {
        OutlineHeadingNode node = new OutlineHeadingNode(parentNode, level, text);
        if (region != null) {
            node.setTextRegion(region);
        }
        return node;
    }

    protected static boolean isSingleLineComment(ILeafNode node) {
        AbstractRule abstractRule;
        EObject eObject;
        return node.isHidden() && (eObject = node.getGrammarElement()) instanceof AbstractRule && "SL_COMMENT".equals((abstractRule = (AbstractRule)eObject).getName());
    }

    protected static int getLevel(IOutlineNode node) {
        if (node instanceof OutlineHeadingNode) {
            OutlineHeadingNode heading = (OutlineHeadingNode)node;
            return heading.getLevel();
        }
        return 0;
    }
}

