/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.text.MessageFormat;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.FordiacKeywords;
import org.eclipse.fordiac.ide.model.Messages;

public final class IdentifierVerifier {
    private static final String IDENTIFIER_REGEX = "[_A-Za-z][_A-Za-z0-9]*+";
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[_A-Za-z][_A-Za-z0-9]*+");

    private IdentifierVerifier() {
        throw new UnsupportedOperationException();
    }

    public static Optional<String> verifyIdentifier(String identifier) {
        return IdentifierVerifier.verifyIdentifier(identifier, null);
    }

    public static Optional<String> verifyIdentifier(String identifier, Object context) {
        if (identifier == null || !IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            return Optional.of(MessageFormat.format(Messages.IdentifierVerifier_NameNotAValidIdentifier, identifier));
        }
        if (identifier.contains("__")) {
            return Optional.of(MessageFormat.format(Messages.IdentifierVerifier_NameConsecutiveUnderscore, identifier));
        }
        if (identifier.endsWith("_")) {
            return Optional.of(MessageFormat.format(Messages.IdentifierVerifier_NameTrailingUnderscore, identifier));
        }
        if (FordiacKeywords.isReservedKeyword(identifier, context)) {
            return Optional.of(MessageFormat.format(Messages.IdentifierVerifier_NameReservedKeyWord, identifier));
        }
        return Optional.empty();
    }

    public static Optional<String> verifyPackageName(String packageName) {
        if (packageName == null || packageName.isEmpty()) {
            return Optional.empty();
        }
        return Stream.of(packageName.split("::", -1)).map(IdentifierVerifier::verifyIdentifier).flatMap(Optional::stream).map(message -> MessageFormat.format(Messages.IdentifierVerifier_PackageNameMessage, message, packageName)).findFirst();
    }
}

