/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit.helper;

import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public final class InitialValueHelper {
    private InitialValueHelper() {
        throw new UnsupportedOperationException("Helper class InitialValueHelper should not be instantiated!");
    }

    public static String getInitialOrDefaultValue(Object element) {
        if (element instanceof VarDeclaration) {
            VarDeclaration varDec = (VarDeclaration)element;
            if (InitialValueHelper.hasInitalValue(element)) {
                return varDec.getValue().getValue();
            }
            if (InitialValueHelper.hasDataTypeInitialValue(varDec)) {
                return InitialValueHelper.getMemberVarValue(varDec);
            }
            return InitialValueHelper.getDefaultValue(element);
        }
        if (element instanceof ErrorMarkerInterface) {
            ErrorMarkerInterface marker = (ErrorMarkerInterface)element;
            if (InitialValueHelper.hasInitalValue(element)) {
                return marker.getValue().getValue();
            }
        }
        if (element instanceof Attribute) {
            Attribute attr = (Attribute)element;
            if (InitialValueHelper.hasInitalValue(element)) {
                return attr.getValue();
            }
            return InitialValueHelper.getDefaultValue(element);
        }
        return "";
    }

    private static boolean hasDataTypeInitialValue(VarDeclaration varDec) {
        if (varDec.getFBNetworkElement() instanceof StructManipulator) {
            return !InitialValueHelper.getMemberVarValue(varDec).isBlank();
        }
        return false;
    }

    private static String getMemberVarValue(VarDeclaration v) {
        StructuredType structType;
        VarDeclaration matchingMember;
        StructManipulator muxer;
        DataType dataType;
        FBNetworkElement fBNetworkElement;
        if (v != null && v.getName() != null && (fBNetworkElement = v.getFBNetworkElement()) instanceof StructManipulator && (dataType = (muxer = (StructManipulator)fBNetworkElement).getDataType()) instanceof StructuredType && (matchingMember = (VarDeclaration)(structType = (StructuredType)dataType).getMemberVariables().stream().filter(member -> v.getName().equals(member.getName())).findFirst().orElse(null)) != null && matchingMember.getValue() != null) {
            return matchingMember.getValue().getValue();
        }
        return "";
    }

    public static String getDefaultValue(Object element) {
        Attribute attr;
        VarDeclaration varDec;
        if (element instanceof VarDeclaration && (varDec = (VarDeclaration)element).getType() instanceof AnyType && !IecTypes.GenericTypes.isAnyType((DataType)varDec.getType())) {
            try {
                return VariableOperations.newVariable((VarDeclaration)varDec).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (element instanceof Attribute && (attr = (Attribute)element).getType() instanceof AnyType && !IecTypes.GenericTypes.isAnyType((DataType)attr.getType())) {
            try {
                return VariableOperations.newVariable((Attribute)attr).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static Color getForegroundColor(Object element) {
        if ((element instanceof VarDeclaration || element instanceof Attribute) && !InitialValueHelper.hasInitalValue(element)) {
            return Display.getCurrent().getSystemColor(16);
        }
        return null;
    }

    public static boolean hasInitalValue(Object element) {
        if (element instanceof VarDeclaration) {
            VarDeclaration varDec = (VarDeclaration)element;
            return varDec.getValue() != null && varDec.getValue().getValue() != null && !varDec.getValue().getValue().isEmpty();
        }
        if (element instanceof ErrorMarkerInterface) {
            ErrorMarkerInterface marker = (ErrorMarkerInterface)element;
            return marker.getValue() != null && marker.getValue().getValue() != null && !marker.getValue().getValue().isEmpty();
        }
        if (element instanceof Attribute) {
            Attribute attr = (Attribute)element;
            return attr.getValue() != null && !attr.getValue().equals("");
        }
        return false;
    }
}

