/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;

public class CreateApplicationCommand
extends CreationCommand {
    private final AutomationSystem system;
    private final String appName;
    private Application application;

    public CreateApplicationCommand(AutomationSystem system, String appName) {
        this.system = system;
        this.appName = appName != null ? appName : "App";
    }

    public boolean canExecute() {
        return this.system != null && this.appName != null;
    }

    public void execute() {
        this.application = LibraryElementFactory.eINSTANCE.createApplication();
        FBNetwork network = LibraryElementFactory.eINSTANCE.createFBNetwork();
        this.application.setFBNetwork(network);
        this.system.getApplication().add((Object)this.application);
        this.application.setName(NameRepository.createUniqueName((INamedElement)this.application, (String)this.appName));
    }

    public void redo() {
        this.system.getApplication().add((Object)this.application);
    }

    public void undo() {
        this.system.getApplication().remove((Object)this.application);
    }

    public Application getCreatedElement() {
        return this.application;
    }
}

