/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.fordiac.ide.model.commands.QualNameChange;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public abstract class QualNameChangeListener {
    protected final HashMap<TypeEntry, List<QualNameChange>> pendingChanges = new HashMap();

    protected abstract List<AbstractOperation> constructExecutableOperations(QualNameChange var1, Object var2);

    protected abstract List<AbstractOperation> constructExecutableUndoOperations(QualNameChange var1, Object var2);

    protected abstract void executeOperation(AbstractOperation var1);

    protected abstract Object getReceiver(TypeEntry var1);

    public void onCommandExecuted(List<QualNameChange> qualNameChange) {
        qualNameChange.forEach(this::onCommandExecuted);
    }

    public void onCommandUndoExecuted(List<QualNameChange> qualNameChange) {
        qualNameChange.forEach(this::onCommandUndoExecuted);
    }

    public void onCommandRedoExecuted(List<QualNameChange> qualNameChange) {
        qualNameChange.forEach(this::onCommandRedoExecuted);
    }

    protected void onCommandExecuted(QualNameChange qualNameChange) {
        if (this.isEnabled(qualNameChange.notifier())) {
            this.addChangeToPendingList(qualNameChange);
        }
    }

    protected void onCommandUndoExecuted(QualNameChange qualNameChange) {
        if (this.isEnabled(qualNameChange.notifier())) {
            this.addChangeToPendingList(qualNameChange);
        }
    }

    void onCommandRedoExecuted(QualNameChange qualNameChange) {
        this.addChangeToPendingList(qualNameChange);
    }

    public void flush(Object notifier) {
        this.pendingChanges.remove(notifier);
    }

    /*
     * WARNING - void declaration
     */
    public void commitOperations(Object notifier) {
        void key;
        if (!(notifier instanceof TypeEntry)) {
            return;
        }
        TypeEntry typeEntry = (TypeEntry)notifier;
        List<QualNameChange> list = this.pendingChanges.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (QualNameChange change : list) {
            List<AbstractOperation> operation = null;
            operation = change.state() == QualNameChangeState.RENAME_UNDO ? this.constructExecutableUndoOperations(change, this.getReceiver((TypeEntry)key)) : this.constructExecutableOperations(change, this.getReceiver((TypeEntry)key));
            if (operation == null || operation.isEmpty()) continue;
            operation.stream().forEach(this::executeOperation);
        }
        this.pendingChanges.remove(key);
    }

    protected void addChangeToPendingList(QualNameChange qualNameChange) {
        List changeList = this.pendingChanges.computeIfAbsent(qualNameChange.key(), key -> new ArrayList());
        changeList.add(qualNameChange);
    }

    protected boolean isEnabled(INamedElement element) {
        return true;
    }

    public static enum QualNameChangeState {
        RENAME,
        RENAME_UNDO,
        RENAME_REDO,
        DELETE,
        DELETE_UNDO,
        DELETE_REDO,
        MOVE;

    }
}

