/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class LibraryChangeListener
implements IResourceChangeListener {
    private static final int MASK = 7;
    private final IResourceDeltaVisitor visitor = delta -> {
        switch (delta.getResource().getType()) {
            case 4: {
                return !LibraryChangeListener.isProjectClosed(delta) && delta.getKind() != 2;
            }
            case 1: {
                IFile file;
                IResource iResource = delta.getResource();
                if (iResource instanceof IFile && "MANIFEST.MF".equals((file = (IFile)iResource).getName()) && (file.getParent() instanceof IProject && (delta.getKind() & 1) != 0 || (file.isLinked() || delta.getKind() == 2) && (delta.getKind() & 7) != 0)) {
                    IProject project = file.getProject();
                    LibraryManager.INSTANCE.startResolveJob(project);
                }
                return false;
            }
            case 2: {
                IResource iResource = delta.getResource();
                if (!(iResource instanceof IFolder)) break;
                IFolder folder = (IFolder)iResource;
                return LibraryChangeListener.isTypeLibraryFolder((IContainer)folder) || (folder.isLinked() || delta.getKind() == 2) && LibraryChangeListener.isTypeLibraryFolder(folder.getParent());
            }
        }
        return true;
    };

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta rootDelta = event.getDelta();
            try {
                rootDelta.accept(this.visitor, 8);
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)"Couldn't process resource delta", (Throwable)e);
            }
        }
    }

    private static boolean isProjectClosed(IResourceDelta delta) {
        return delta.getKind() != 4 && (delta.getFlags() & 0x4000) == 16384 && !delta.getResource().isAccessible();
    }

    private static boolean isTypeLibraryFolder(IContainer container) {
        return container instanceof IFolder && container.getParent() instanceof IProject && ("Standard Libraries".equals(container.getName()) || "External Libraries".equals(container.getName()));
    }
}

