/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_lua.st;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.data.AnyNumType;
import org.eclipse.fordiac.ide.model.data.AnyRealType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.ByteType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.data.DwordType;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.data.LtimeType;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.data.LwordType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.data.TimeType;
import org.eclipse.fordiac.ide.model.data.WordType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.value.ValueConverter;
import org.eclipse.fordiac.ide.model.value.ValueConverterFactory;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseCases;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateAndTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElementaryInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElseIfPart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElsePart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNop;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STReturn;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSingleArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStringLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeOfDayLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public abstract class StructuredTextSupport
implements ILanguageSupport {
    @Accessors
    private final List<String> errors = CollectionLiterals.newArrayList();
    @Accessors
    private final List<String> warnings = CollectionLiterals.newArrayList();
    @Accessors
    private final List<String> infos = CollectionLiterals.newArrayList();
    private int uniqueVariableIndex = 0;
    private int loopIndex = 0;
    private Stack<String> loopStack = new Stack();

    protected CharSequence generateFBVariablePrefix(InterfaceList vars) {
        StringConcatenation _builder = new StringConcatenation();
        EList _inputVars = vars.getInputVars();
        for (VarDeclaration in : _inputVars) {
            _builder.append("ENV.fb_var_");
            String _name = in.getName();
            _builder.append(_name);
            _builder.append(" = fb[DI_");
            String _name_1 = in.getName();
            _builder.append(_name_1);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
        }
        EList _outputVars = vars.getOutputVars();
        for (VarDeclaration out : _outputVars) {
            _builder.append("ENV.fb_var_");
            String _name_2 = out.getName();
            _builder.append(_name_2);
            _builder.append(" = fb[DO_");
            String _name_3 = out.getName();
            _builder.append(_name_3);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateFBVariableSuffix(InterfaceList vars) {
        StringConcatenation _builder = new StringConcatenation();
        EList _outputVars = vars.getOutputVars();
        for (VarDeclaration out : _outputVars) {
            _builder.append("fb[DO_");
            String _name = out.getName();
            _builder.append(_name);
            _builder.append("] = ENV.fb_var_");
            String _name_1 = out.getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateInternalVariablePrefix(Iterable<? extends VarDeclaration> vars) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration varDeclaration : vars) {
            _builder.append("ENV.fb_var_");
            String _name = varDeclaration.getName();
            _builder.append(_name);
            _builder.append(" = fb[IN_");
            String _name_1 = varDeclaration.getName();
            _builder.append(_name_1);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateInternalVariableSuffix(Iterable<? extends VarDeclaration> vars) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration varDeclaration : vars) {
            _builder.append("fb[IN_");
            String _name = varDeclaration.getName();
            _builder.append(_name);
            _builder.append("] = ENV.fb_var_");
            String _name_1 = varDeclaration.getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateLocalVariables(Iterable<? extends STVarDeclarationBlock> blocks) {
        StringConcatenation _builder = new StringConcatenation();
        for (STVarDeclarationBlock sTVarDeclarationBlock : blocks) {
            CharSequence _generateLocalVariableBlock = this.generateLocalVariableBlock(sTVarDeclarationBlock);
            _builder.append((Object)_generateLocalVariableBlock);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateLocalVariableBlock(STVarDeclarationBlock block) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter((Iterable)block.getVarDeclarations(), STVarDeclaration.class);
        for (STVarDeclaration variable : _filter) {
            CharSequence _generateLocalVariable = this.generateLocalVariable(variable, block.isConstant());
            _builder.append((Object)_generateLocalVariable);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateLocalVariable(STVarDeclaration variable, boolean const_) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateFeatureName = this.generateFeatureName((INamedElement)variable, false);
        _builder.append((Object)_generateFeatureName);
        _builder.append(" = ");
        boolean _isArray = variable.isArray();
        if (_isArray) {
            boolean _tripleNotEquals;
            _builder.append("STfunc.array({");
            CharSequence _generateArrayRanges = this.generateArrayRanges(variable);
            _builder.append((Object)_generateArrayRanges);
            _builder.append("}, ");
            INamedElement _type = variable.getType();
            CharSequence _generateTypeDefaultValue = StructuredTextSupport.generateTypeDefaultValue((DataType)_type);
            _builder.append((Object)_generateTypeDefaultValue);
            _builder.append(", ");
            STInitializerExpression _defaultValue = variable.getDefaultValue();
            boolean bl = _tripleNotEquals = _defaultValue != null;
            if (_tripleNotEquals) {
                CharSequence _generateInitializerExpression = this.generateInitializerExpression(variable.getDefaultValue());
                _builder.append((Object)_generateInitializerExpression);
            } else {
                _builder.append("{nil}");
            }
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        } else {
            boolean _tripleNotEquals_1;
            STInitializerExpression _defaultValue_1 = variable.getDefaultValue();
            boolean bl = _tripleNotEquals_1 = _defaultValue_1 != null;
            if (_tripleNotEquals_1) {
                CharSequence _generateInitializerExpression_1 = this.generateInitializerExpression(variable.getDefaultValue());
                _builder.append((Object)_generateInitializerExpression_1);
            } else {
                INamedElement _type_1 = variable.getType();
                CharSequence _generateTypeDefaultValue_1 = StructuredTextSupport.generateTypeDefaultValue((DataType)_type_1);
                _builder.append((Object)_generateTypeDefaultValue_1);
            }
        }
        return _builder;
    }

    protected CharSequence generateArrayRanges(STVarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        EList _ranges = variable.getRanges();
        boolean _hasElements = false;
        for (STExpression range : _ranges) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("{");
            CharSequence _generateExpression = this.generateExpression(((STBinaryExpression)range).getLeft());
            _builder.append((Object)_generateExpression);
            _builder.append(", ");
            CharSequence _generateExpression_1 = this.generateExpression(((STBinaryExpression)range).getRight());
            _builder.append((Object)_generateExpression_1);
            _builder.append("}");
        }
        return _builder;
    }

    protected CharSequence _generateInitializerExpression(STElementaryInitializerExpression expr) {
        return this.generateExpression(expr.getValue());
    }

    protected CharSequence _generateInitializerExpression(STArrayInitializerExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        EList _values = expr.getValues();
        boolean _hasElements = false;
        for (STArrayInitElement elem : _values) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateArrayInitElement = this.generateArrayInitElement(elem);
            _builder.append((Object)_generateArrayInitElement);
        }
        _builder.append("}");
        return _builder;
    }

    protected CharSequence _generateArrayInitElement(STSingleArrayInitElement elem) {
        return this.generateInitializerExpression(elem.getInitExpression());
    }

    protected CharSequence _generateArrayInitElement(STRepeatArrayInitElement elem) {
        StringConcatenation _builder = new StringConcatenation();
        int _intValueExact = elem.getRepetitions().intValueExact();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _intValueExact, true);
        boolean _hasElements = false;
        for (Integer i : _doubleDotLessThan) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            EList _initExpressions = elem.getInitExpressions();
            boolean _hasElements_1 = false;
            for (STInitializerExpression initExpression : _initExpressions) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _generateInitializerExpression = this.generateInitializerExpression(initExpression);
                _builder.append((Object)_generateInitializerExpression);
            }
        }
        return _builder;
    }

    protected CharSequence generateStatementList(List<STStatement> statements) {
        StringConcatenation _builder = new StringConcatenation();
        for (STStatement statement : statements) {
            CharSequence _generateStatement = this.generateStatement(statement);
            _builder.append((Object)_generateStatement);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateStatement(STStatement stmt) {
        StringConcatenation _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The statement ");
        String _name = stmt.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("#error \"The statement ");
        String _name_1 = stmt.eClass().getName();
        _builder_1.append(_name_1);
        _builder_1.append(" is not supported\"");
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    protected CharSequence _generateStatement(STNop stmt) {
        return "";
    }

    protected CharSequence _generateStatement(STIfStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if ");
        CharSequence _generateExpression = this.generateExpression(stmt.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.append(" then");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        EList _elseifs = stmt.getElseifs();
        for (STElseIfPart elseif : _elseifs) {
            _builder.append("elsif ");
            CharSequence _generateExpression_1 = this.generateExpression(elseif.getCondition());
            _builder.append((Object)_generateExpression_1);
            _builder.append(" then");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            CharSequence _generateStatementList_1 = this.generateStatementList((List<STStatement>)elseif.getStatements());
            _builder.append((Object)_generateStatementList_1, "  ");
            _builder.newLineIfNotEmpty();
        }
        STElsePart _else = stmt.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("else");
            _builder.newLine();
            _builder.append("  ");
            CharSequence _generateStatementList_2 = this.generateStatementList((List<STStatement>)stmt.getElse().getStatements());
            _builder.append((Object)_generateStatementList_2, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("end");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateStatement(STCaseStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence selector = this.generateExpression(stmt.getSelector());
        _builder.newLineIfNotEmpty();
        _builder.append("if ");
        EList _cases = stmt.getCases();
        boolean _hasElements = false;
        for (STCaseCases clause : _cases) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" elsif ", "");
            }
            CharSequence _generateCaseClause = this.generateCaseClause(clause, selector);
            _builder.append((Object)_generateCaseClause);
        }
        _builder.newLineIfNotEmpty();
        STElsePart _else = stmt.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("else");
            _builder.newLine();
            _builder.append("  ");
            CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getElse().getStatements());
            _builder.append((Object)_generateStatementList, "  ");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateCaseClause(STCaseCases clause, CharSequence selector) {
        StringConcatenation _builder = new StringConcatenation();
        EList _conditions = clause.getConditions();
        boolean _hasElements = false;
        for (STExpression value : _conditions) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" or ", "");
            }
            _builder.append((Object)selector);
            _builder.append(" == ");
            CharSequence _generateExpression = this.generateExpression(value);
            _builder.append((Object)_generateExpression);
        }
        _builder.append(" then");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)clause.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateStatement(STForStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        this.loopStack.push("loop_" + String.valueOf((Object)this.loopIndex));
        ++this.loopIndex;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("for ");
        CharSequence _generateExpression = this.generateExpression(stmt.getVariable());
        _builder.append((Object)_generateExpression);
        _builder.append(" = ");
        CharSequence _generateExpression_1 = this.generateExpression(stmt.getFrom());
        _builder.append((Object)_generateExpression_1);
        _builder.append(", ");
        CharSequence _generateExpression_2 = this.generateExpression(stmt.getTo());
        _builder.append((Object)_generateExpression_2);
        _builder.append(", ");
        STExpression _by = stmt.getBy();
        boolean bl = _tripleNotEquals = _by != null;
        if (_tripleNotEquals) {
            CharSequence _generateExpression_3 = this.generateExpression(stmt.getBy());
            _builder.append((Object)_generateExpression_3);
        } else {
            _builder.append("1");
        }
        _builder.append(" do");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("::");
        String _pop = this.loopStack.pop();
        _builder.append(_pop, "  ");
        _builder.append("::");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _generateStatement(STWhileStatement stmt) {
        StringConcatenation _xblockexpression = null;
        this.loopStack.push("loop_" + String.valueOf((Object)this.loopIndex));
        ++this.loopIndex;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("while ");
        CharSequence _generateExpression = this.generateExpression(stmt.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.append(" do");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("::");
        String _pop = this.loopStack.pop();
        _builder.append(_pop, "  ");
        _builder.append("::");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _generateStatement(STRepeatStatement stmt) {
        StringConcatenation _xblockexpression = null;
        this.loopStack.push("loop_" + String.valueOf((Object)this.loopIndex));
        ++this.loopIndex;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("repeat");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("::");
        String _pop = this.loopStack.pop();
        _builder.append(_pop, "  ");
        _builder.append("::");
        _builder.newLineIfNotEmpty();
        _builder.append("until ");
        CharSequence _generateExpression = this.generateExpression(stmt.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _generateStatement(STContinue stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("goto ");
        String _peek = this.loopStack.peek();
        _builder.append(_peek);
        return _builder;
    }

    protected CharSequence _generateStatement(STReturn stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return");
        return _builder;
    }

    protected CharSequence _generateStatement(STExit stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("break");
        return _builder;
    }

    protected CharSequence _generateStatement(STExpression stmt) {
        return this.generateExpression(stmt);
    }

    protected CharSequence _generateExpression(STExpression expr) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The expression ");
        String _name = expr.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        _xblockexpression = "";
        return _xblockexpression;
    }

    protected CharSequence _generateExpression(STAssignment expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
        _builder.append((Object)_generateExpression);
        _builder.append(" = ");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
        _builder.append((Object)_generateExpression_1);
        return _builder;
    }

    protected CharSequence _generateExpression(STBinaryExpression expr) {
        StringConcatenation _switchResult = null;
        STBinaryOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case OR: {
                    StringConcatenation _xifexpression = null;
                    INamedElement _resultType = expr.getLeft().getResultType();
                    if (_resultType instanceof BoolType) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("(");
                        CharSequence _generateExpression = this.generateExpression(expr.getLeft());
                        _builder.append((Object)_generateExpression);
                        _builder.append(" or ");
                        CharSequence _generateExpression_1 = this.generateExpression(expr.getRight());
                        _builder.append((Object)_generateExpression_1);
                        _builder.append(")");
                        _xifexpression = _builder;
                    } else {
                        StringConcatenation _xifexpression_1 = null;
                        INamedElement _resultType_1 = expr.getLeft().getResultType();
                        if (_resultType_1 instanceof LwordType) {
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("STfunc.OR64(");
                            CharSequence _generateExpression_2 = this.generateExpression(expr.getLeft());
                            _builder_1.append((Object)_generateExpression_2);
                            _builder_1.append(", ");
                            CharSequence _generateExpression_3 = this.generateExpression(expr.getRight());
                            _builder_1.append((Object)_generateExpression_3);
                            _builder_1.append(")");
                            _xifexpression_1 = _builder_1;
                        } else {
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append("STfunc.OR(");
                            CharSequence _generateExpression_4 = this.generateExpression(expr.getLeft());
                            _builder_2.append((Object)_generateExpression_4);
                            _builder_2.append(", ");
                            CharSequence _generateExpression_5 = this.generateExpression(expr.getRight());
                            _builder_2.append((Object)_generateExpression_5);
                            _builder_2.append(")");
                            _xifexpression_1 = _builder_2;
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    _switchResult = _xifexpression;
                    break;
                }
                case XOR: {
                    StringConcatenation _xifexpression_2 = null;
                    INamedElement _resultType_2 = expr.getLeft().getResultType();
                    if (_resultType_2 instanceof BoolType) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("(");
                        CharSequence _generateExpression_6 = this.generateExpression(expr.getLeft());
                        _builder_3.append((Object)_generateExpression_6);
                        _builder_3.append(" ~= ");
                        CharSequence _generateExpression_7 = this.generateExpression(expr.getRight());
                        _builder_3.append((Object)_generateExpression_7);
                        _builder_3.append(")");
                        _xifexpression_2 = _builder_3;
                    } else {
                        StringConcatenation _xifexpression_3 = null;
                        INamedElement _resultType_3 = expr.getLeft().getResultType();
                        if (_resultType_3 instanceof LwordType) {
                            StringConcatenation _builder_4 = new StringConcatenation();
                            _builder_4.append("STfunc.XOR64(");
                            CharSequence _generateExpression_8 = this.generateExpression(expr.getLeft());
                            _builder_4.append((Object)_generateExpression_8);
                            _builder_4.append(", ");
                            CharSequence _generateExpression_9 = this.generateExpression(expr.getRight());
                            _builder_4.append((Object)_generateExpression_9);
                            _builder_4.append(")");
                            _xifexpression_3 = _builder_4;
                        } else {
                            StringConcatenation _builder_5 = new StringConcatenation();
                            _builder_5.append("STfunc.XOR(");
                            CharSequence _generateExpression_10 = this.generateExpression(expr.getLeft());
                            _builder_5.append((Object)_generateExpression_10);
                            _builder_5.append(", ");
                            CharSequence _generateExpression_11 = this.generateExpression(expr.getRight());
                            _builder_5.append((Object)_generateExpression_11);
                            _builder_5.append(")");
                            _xifexpression_3 = _builder_5;
                        }
                        _xifexpression_2 = _xifexpression_3;
                    }
                    _switchResult = _xifexpression_2;
                    break;
                }
                case AND: {
                    StringConcatenation _xifexpression_4 = null;
                    INamedElement _resultType_4 = expr.getLeft().getResultType();
                    if (_resultType_4 instanceof BoolType) {
                        StringConcatenation _builder_6 = new StringConcatenation();
                        _builder_6.append("(");
                        CharSequence _generateExpression_12 = this.generateExpression(expr.getLeft());
                        _builder_6.append((Object)_generateExpression_12);
                        _builder_6.append(" and ");
                        CharSequence _generateExpression_13 = this.generateExpression(expr.getRight());
                        _builder_6.append((Object)_generateExpression_13);
                        _builder_6.append(")");
                        return _builder_6;
                    }
                    StringConcatenation _xifexpression_5 = null;
                    INamedElement _resultType_5 = expr.getLeft().getResultType();
                    if (_resultType_5 instanceof LwordType) {
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append("STfunc.AND64(");
                        CharSequence _generateExpression_14 = this.generateExpression(expr.getLeft());
                        _builder_7.append((Object)_generateExpression_14);
                        _builder_7.append(", ");
                        CharSequence _generateExpression_15 = this.generateExpression(expr.getRight());
                        _builder_7.append((Object)_generateExpression_15);
                        _builder_7.append(")");
                        _xifexpression_5 = _builder_7;
                    } else {
                        StringConcatenation _builder_8 = new StringConcatenation();
                        _builder_8.append("STfunc.AND(");
                        CharSequence _generateExpression_16 = this.generateExpression(expr.getLeft());
                        _builder_8.append((Object)_generateExpression_16);
                        _builder_8.append(", ");
                        CharSequence _generateExpression_17 = this.generateExpression(expr.getRight());
                        _builder_8.append((Object)_generateExpression_17);
                        _builder_8.append(")");
                        _xifexpression_5 = _builder_8;
                    }
                    _switchResult = _xifexpression_4 = _xifexpression_5;
                    break;
                }
                case AMPERSAND: {
                    StringConcatenation _builder_9 = new StringConcatenation();
                    _builder_9.append("(");
                    CharSequence _generateExpression_18 = this.generateExpression(expr.getLeft());
                    _builder_9.append((Object)_generateExpression_18);
                    _builder_9.append(" and ");
                    CharSequence _generateExpression_19 = this.generateExpression(expr.getRight());
                    _builder_9.append((Object)_generateExpression_19);
                    _builder_9.append(")");
                    _switchResult = _builder_9;
                    break;
                }
                case EQ: {
                    StringConcatenation _builder_10 = new StringConcatenation();
                    _builder_10.append("(");
                    CharSequence _generateExpression_20 = this.generateExpression(expr.getLeft());
                    _builder_10.append((Object)_generateExpression_20);
                    _builder_10.append(" == ");
                    CharSequence _generateExpression_21 = this.generateExpression(expr.getRight());
                    _builder_10.append((Object)_generateExpression_21);
                    _builder_10.append(")");
                    _switchResult = _builder_10;
                    break;
                }
                case NE: {
                    StringConcatenation _builder_11 = new StringConcatenation();
                    _builder_11.append("(");
                    CharSequence _generateExpression_22 = this.generateExpression(expr.getLeft());
                    _builder_11.append((Object)_generateExpression_22);
                    _builder_11.append(" ~= ");
                    CharSequence _generateExpression_23 = this.generateExpression(expr.getRight());
                    _builder_11.append((Object)_generateExpression_23);
                    _builder_11.append(")");
                    _switchResult = _builder_11;
                    break;
                }
                case LT: {
                    StringConcatenation _builder_12 = new StringConcatenation();
                    _builder_12.append("(");
                    CharSequence _generateExpression_24 = this.generateExpression(expr.getLeft());
                    _builder_12.append((Object)_generateExpression_24);
                    _builder_12.append(" < ");
                    CharSequence _generateExpression_25 = this.generateExpression(expr.getRight());
                    _builder_12.append((Object)_generateExpression_25);
                    _builder_12.append(")");
                    _switchResult = _builder_12;
                    break;
                }
                case LE: {
                    StringConcatenation _builder_13 = new StringConcatenation();
                    _builder_13.append("(");
                    CharSequence _generateExpression_26 = this.generateExpression(expr.getLeft());
                    _builder_13.append((Object)_generateExpression_26);
                    _builder_13.append(" <= ");
                    CharSequence _generateExpression_27 = this.generateExpression(expr.getRight());
                    _builder_13.append((Object)_generateExpression_27);
                    _builder_13.append(")");
                    _switchResult = _builder_13;
                    break;
                }
                case GT: {
                    StringConcatenation _builder_14 = new StringConcatenation();
                    _builder_14.append("(");
                    CharSequence _generateExpression_28 = this.generateExpression(expr.getLeft());
                    _builder_14.append((Object)_generateExpression_28);
                    _builder_14.append(" > ");
                    CharSequence _generateExpression_29 = this.generateExpression(expr.getRight());
                    _builder_14.append((Object)_generateExpression_29);
                    _builder_14.append(")");
                    _switchResult = _builder_14;
                    break;
                }
                case GE: {
                    StringConcatenation _builder_15 = new StringConcatenation();
                    _builder_15.append("(");
                    CharSequence _generateExpression_30 = this.generateExpression(expr.getLeft());
                    _builder_15.append((Object)_generateExpression_30);
                    _builder_15.append(" >= ");
                    CharSequence _generateExpression_31 = this.generateExpression(expr.getRight());
                    _builder_15.append((Object)_generateExpression_31);
                    _builder_15.append(")");
                    _switchResult = _builder_15;
                    break;
                }
                case ADD: {
                    StringConcatenation _xifexpression_6 = null;
                    INamedElement _resultType_6 = expr.getLeft().getResultType();
                    if (_resultType_6 instanceof AnyNumType) {
                        StringConcatenation _builder_16 = new StringConcatenation();
                        _builder_16.append("(");
                        CharSequence _generateExpression_32 = this.generateExpression(expr.getLeft());
                        _builder_16.append((Object)_generateExpression_32);
                        _builder_16.append(" + ");
                        CharSequence _generateExpression_33 = this.generateExpression(expr.getRight());
                        _builder_16.append((Object)_generateExpression_33);
                        _builder_16.append(")");
                        _xifexpression_6 = _builder_16;
                    } else {
                        StringConcatenation _xifexpression_7 = null;
                        INamedElement _resultType_7 = expr.getLeft().getResultType();
                        if (_resultType_7 instanceof AnyDurationType) {
                            StringConcatenation _builder_17 = new StringConcatenation();
                            _builder_17.append("(");
                            CharSequence _generateExpression_34 = this.generateExpression(expr.getLeft());
                            _builder_17.append((Object)_generateExpression_34);
                            _builder_17.append(" + ");
                            CharSequence _generateExpression_35 = this.generateExpression(expr.getRight());
                            _builder_17.append((Object)_generateExpression_35);
                            _builder_17.append(")");
                            _xifexpression_7 = _builder_17;
                        } else {
                            StringConcatenation _builder_19;
                            StringConcatenation _xblockexpression = null;
                            StringConcatenation _builder_18 = new StringConcatenation();
                            _builder_18.append("The ADD operation for ");
                            String _name = expr.getLeft().getResultType().getName();
                            _builder_18.append(_name);
                            _builder_18.append(" is not yet supported");
                            this.errors.add(_builder_18.toString());
                            _xifexpression_7 = _xblockexpression = (_builder_19 = new StringConcatenation());
                        }
                        _xifexpression_6 = _xifexpression_7;
                    }
                    _switchResult = _xifexpression_6;
                    break;
                }
                case SUB: {
                    StringConcatenation _xifexpression_8 = null;
                    INamedElement _resultType_8 = expr.getLeft().getResultType();
                    if (_resultType_8 instanceof AnyNumType) {
                        StringConcatenation _builder_18 = new StringConcatenation();
                        _builder_18.append("(");
                        CharSequence _generateExpression_36 = this.generateExpression(expr.getLeft());
                        _builder_18.append((Object)_generateExpression_36);
                        _builder_18.append(" - ");
                        CharSequence _generateExpression_37 = this.generateExpression(expr.getRight());
                        _builder_18.append((Object)_generateExpression_37);
                        _builder_18.append(")");
                        _xifexpression_8 = _builder_18;
                    } else {
                        StringConcatenation _xifexpression_9 = null;
                        INamedElement _resultType_9 = expr.getLeft().getResultType();
                        if (_resultType_9 instanceof AnyDurationType) {
                            StringConcatenation _builder_19 = new StringConcatenation();
                            _builder_19.append("(");
                            CharSequence _generateExpression_38 = this.generateExpression(expr.getLeft());
                            _builder_19.append((Object)_generateExpression_38);
                            _builder_19.append(" - ");
                            CharSequence _generateExpression_39 = this.generateExpression(expr.getRight());
                            _builder_19.append((Object)_generateExpression_39);
                            _builder_19.append(")");
                            _xifexpression_9 = _builder_19;
                        } else {
                            StringConcatenation _builder_21;
                            StringConcatenation _xblockexpression_1 = null;
                            StringConcatenation _builder_20 = new StringConcatenation();
                            _builder_20.append("The SUB operation for ");
                            String _name = expr.getLeft().getResultType().getName();
                            _builder_20.append(_name);
                            _builder_20.append(" is not yet supported");
                            this.errors.add(_builder_20.toString());
                            _xifexpression_9 = _xblockexpression_1 = (_builder_21 = new StringConcatenation());
                        }
                        _xifexpression_8 = _xifexpression_9;
                    }
                    _switchResult = _xifexpression_8;
                    break;
                }
                case MUL: {
                    StringConcatenation _builder_20 = new StringConcatenation();
                    _builder_20.append("(");
                    CharSequence _generateExpression_40 = this.generateExpression(expr.getLeft());
                    _builder_20.append((Object)_generateExpression_40);
                    _builder_20.append(" * ");
                    CharSequence _generateExpression_41 = this.generateExpression(expr.getRight());
                    _builder_20.append((Object)_generateExpression_41);
                    _builder_20.append(")");
                    _switchResult = _builder_20;
                    break;
                }
                case DIV: {
                    StringConcatenation _xifexpression_10 = null;
                    if (expr.getLeft().getResultType() instanceof AnyRealType || expr.getRight().getResultType() instanceof AnyRealType) {
                        StringConcatenation _builder_21 = new StringConcatenation();
                        _builder_21.append("(");
                        CharSequence _generateExpression_42 = this.generateExpression(expr.getLeft());
                        _builder_21.append((Object)_generateExpression_42);
                        _builder_21.append(" / ");
                        CharSequence _generateExpression_43 = this.generateExpression(expr.getRight());
                        _builder_21.append((Object)_generateExpression_43);
                        _builder_21.append(")");
                        _xifexpression_10 = _builder_21;
                    } else {
                        StringConcatenation _builder_22 = new StringConcatenation();
                        _builder_22.append("math.floor(");
                        CharSequence _generateExpression_44 = this.generateExpression(expr.getLeft());
                        _builder_22.append((Object)_generateExpression_44);
                        _builder_22.append(" / ");
                        CharSequence _generateExpression_45 = this.generateExpression(expr.getRight());
                        _builder_22.append((Object)_generateExpression_45);
                        _builder_22.append(")");
                        _xifexpression_10 = _builder_22;
                    }
                    _switchResult = _xifexpression_10;
                    break;
                }
                case MOD: {
                    StringConcatenation _builder_23 = new StringConcatenation();
                    _builder_23.append("(");
                    CharSequence _generateExpression_46 = this.generateExpression(expr.getLeft());
                    _builder_23.append((Object)_generateExpression_46);
                    _builder_23.append(" % ");
                    CharSequence _generateExpression_47 = this.generateExpression(expr.getRight());
                    _builder_23.append((Object)_generateExpression_47);
                    _builder_23.append(")");
                    _switchResult = _builder_23;
                    break;
                }
                case POWER: {
                    StringConcatenation _builder_24 = new StringConcatenation();
                    _builder_24.append("(");
                    CharSequence _generateExpression_48 = this.generateExpression(expr.getLeft());
                    _builder_24.append((Object)_generateExpression_48);
                    _builder_24.append("^");
                    CharSequence _generateExpression_49 = this.generateExpression(expr.getRight());
                    _builder_24.append((Object)_generateExpression_49);
                    _builder_24.append(")");
                    _switchResult = _builder_24;
                    break;
                }
                default: {
                    StringConcatenation _builder_26;
                    StringConcatenation _xblockexpression_2 = null;
                    StringConcatenation _builder_25 = new StringConcatenation();
                    _builder_25.append("The operation ");
                    String _name = expr.getOp().getName();
                    _builder_25.append(_name);
                    _builder_25.append(" is not supported");
                    this.errors.add(_builder_25.toString());
                    _switchResult = _xblockexpression_2 = (_builder_26 = new StringConcatenation());
                    break;
                }
            }
        } else {
            StringConcatenation _builder_26;
            StringConcatenation _xblockexpression_2 = null;
            StringConcatenation _builder_25 = new StringConcatenation();
            _builder_25.append("The operation ");
            String _name = expr.getOp().getName();
            _builder_25.append(_name);
            _builder_25.append(" is not supported");
            this.errors.add(_builder_25.toString());
            _switchResult = _xblockexpression_2 = (_builder_26 = new StringConcatenation());
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(STUnaryExpression expr) {
        StringConcatenation _switchResult = null;
        STUnaryOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case MINUS: {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("-");
                    CharSequence _generateExpression = this.generateExpression(expr.getExpression());
                    _builder.append((Object)_generateExpression);
                    _switchResult = _builder;
                    break;
                }
                case PLUS: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    CharSequence _generateExpression_1 = this.generateExpression(expr.getExpression());
                    _builder_1.append((Object)_generateExpression_1);
                    _switchResult = _builder_1;
                    break;
                }
                case NOT: {
                    String bits = "";
                    INamedElement _resultType = expr.getResultType();
                    if (_resultType instanceof BoolType) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("(not ");
                        CharSequence _generateExpression_2 = this.generateExpression(expr.getExpression());
                        _builder_2.append((Object)_generateExpression_2);
                        _builder_2.append(")");
                        return _builder_2;
                    }
                    INamedElement _resultType_1 = expr.getResultType();
                    if (_resultType_1 instanceof ByteType) {
                        bits = "8";
                    } else {
                        INamedElement _resultType_2 = expr.getResultType();
                        if (_resultType_2 instanceof WordType) {
                            bits = "16";
                        } else {
                            INamedElement _resultType_3 = expr.getResultType();
                            if (_resultType_3 instanceof DwordType) {
                                bits = "32";
                            } else {
                                INamedElement _resultType_4 = expr.getResultType();
                                if (_resultType_4 instanceof LwordType) {
                                    bits = "64";
                                }
                            }
                        }
                    }
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("STfunc.NOT");
                    _builder_3.append(bits);
                    _builder_3.append("(");
                    CharSequence _generateExpression_3 = this.generateExpression(expr.getExpression());
                    _builder_3.append((Object)_generateExpression_3);
                    _builder_3.append(")");
                    return _builder_3;
                }
                default: {
                    StringConcatenation _builder_5;
                    StringConcatenation _xblockexpression = null;
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("The operation ");
                    String _name = expr.getOp().getName();
                    _builder_4.append(_name);
                    _builder_4.append(" is not supported");
                    this.errors.add(_builder_4.toString());
                    _switchResult = _xblockexpression = (_builder_5 = new StringConcatenation());
                    break;
                }
            }
        } else {
            StringConcatenation _builder_5;
            StringConcatenation _xblockexpression = null;
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("The operation ");
            String _name = expr.getOp().getName();
            _builder_4.append(_name);
            _builder_4.append(" is not supported");
            this.errors.add(_builder_4.toString());
            _switchResult = _xblockexpression = (_builder_5 = new StringConcatenation());
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(STMemberAccessExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(expr.getReceiver());
        _builder.append((Object)_generateExpression);
        _builder.append(".");
        CharSequence _generateExpression_1 = this.generateExpression(expr.getMember());
        _builder.append((Object)_generateExpression_1);
        return _builder;
    }

    protected CharSequence _generateExpression(STArrayAccessExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression(expr.getReceiver());
        _builder.append((Object)_generateExpression);
        EList _index = expr.getIndex();
        for (STExpression index : _index) {
            _builder.append("[");
            CharSequence _generateExpression_1 = this.generateExpression(index);
            _builder.append((Object)_generateExpression_1);
            _builder.append("]");
        }
        return _builder;
    }

    protected CharSequence _generateExpression(STFeatureExpression expr) {
        StringConcatenation _xblockexpression;
        block549: {
            block550: {
                String addPars;
                String call;
                block553: {
                    block551: {
                        _xblockexpression = null;
                        boolean _isCall = expr.isCall();
                        if (!_isCall) break block549;
                        INamedElement _feature = expr.getFeature();
                        if (!(_feature instanceof STStandardFunction)) break block550;
                        String name = expr.getFeature().getName().toLowerCase();
                        call = "";
                        addPars = "";
                        INamedElement _feature_1 = expr.getFeature();
                        DataType type = ((STStandardFunction)_feature_1).getReturnType();
                        if (name == null) break block551;
                        switch (name) {
                            case "ln": 
                            case "abs": 
                            case "sqrt": {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append("math.");
                                _builder.append(name);
                                call = _builder.toString();
                                break;
                            }
                            case "log": {
                                call = "math.ln";
                                addPars = ", 10";
                                break;
                            }
                            case "cos": 
                            case "exp": 
                            case "sin": 
                            case "tan": 
                            case "acos": 
                            case "asin": 
                            case "atan": {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append("math.");
                                _builder_1.append(name);
                                call = _builder_1.toString();
                                break;
                            }
                            case "atan2": {
                                call = "math.atan";
                                break;
                            }
                            case "max": 
                            case "min": {
                                StringConcatenation _builder_2 = new StringConcatenation();
                                _builder_2.append("math.");
                                _builder_2.append(name);
                                call = _builder_2.toString();
                                break;
                            }
                            case "mux": 
                            case "sel": 
                            case "limit": {
                                StringConcatenation _builder_3 = new StringConcatenation();
                                _builder_3.append("STfunc.");
                                String _upperCase = name.toUpperCase();
                                _builder_3.append(_upperCase);
                                call = _builder_3.toString();
                                break;
                            }
                            case "rol": 
                            case "ror": 
                            case "shl": 
                            case "shr": {
                                String bits = "";
                                if (type instanceof BoolType) {
                                    bits = "1";
                                } else if (type instanceof ByteType) {
                                    bits = "8";
                                } else if (type instanceof WordType) {
                                    bits = "16";
                                } else if (type instanceof DwordType) {
                                    bits = "32";
                                } else if (type instanceof LwordType) {
                                    bits = "64";
                                }
                                StringConcatenation _builder_4 = new StringConcatenation();
                                _builder_4.append("STfunc.");
                                String _upperCase_1 = name.toUpperCase();
                                _builder_4.append(_upperCase_1);
                                _builder_4.append(bits);
                                call = _builder_4.toString();
                                break;
                            }
                            case "lower_bound": 
                            case "upper_bound": {
                                StringConcatenation _builder_5 = new StringConcatenation();
                                _builder_5.append("STfunc.");
                                String _upperCase_2 = name.toUpperCase();
                                _builder_5.append(_upperCase_2);
                                call = _builder_5.toString();
                                break;
                            }
                            case "bool_to_dword": 
                            case "bool_to_lword": 
                            case "bool_to_udint": 
                            case "bool_to_ulint": 
                            case "bool_to_usint": 
                            case "bool_to_byte": 
                            case "bool_to_dint": 
                            case "bool_to_lint": 
                            case "bool_to_sint": 
                            case "bool_to_uint": 
                            case "bool_to_word": 
                            case "bool_to_int": {
                                StringConcatenation _builder_6 = new StringConcatenation();
                                _builder_6.append("STfunc.BOOL_TO_INT");
                                call = _builder_6.toString();
                                break;
                            }
                            case "byte_to_bool": {
                                StringConcatenation _builder_7 = new StringConcatenation();
                                _builder_7.append("STfunc.BYTE_TO_BOOL");
                                call = _builder_7.toString();
                                break;
                            }
                            case "byte_to_char": {
                                StringConcatenation _builder_8 = new StringConcatenation();
                                _builder_8.append("string.char");
                                call = _builder_8.toString();
                                break;
                            }
                            case "byte_to_dint": 
                            case "byte_to_lint": 
                            case "byte_to_sint": 
                            case "byte_to_uint": 
                            case "byte_to_word": 
                            case "byte_to_int": 
                            case "byte_to_dword": 
                            case "byte_to_lword": 
                            case "byte_to_udint": 
                            case "byte_to_ulint": 
                            case "byte_to_usint": {
                                StringConcatenation _builder_9 = new StringConcatenation();
                                call = _builder_9.toString();
                                break;
                            }
                            case "word_to_bool": {
                                StringConcatenation _builder_10 = new StringConcatenation();
                                _builder_10.append("STfunc.BYTE_TO_BOOL");
                                call = _builder_10.toString();
                                break;
                            }
                            case "word_to_byte": {
                                StringConcatenation _builder_11 = new StringConcatenation();
                                _builder_11.append("STfunc.VAL_TO_BYTE");
                                call = _builder_11.toString();
                                break;
                            }
                            case "word_to_dword": 
                            case "word_to_lword": {
                                StringConcatenation _builder_12 = new StringConcatenation();
                                call = _builder_12.toString();
                                break;
                            }
                            case "word_to_usint": 
                            case "word_to_sint": {
                                StringConcatenation _builder_13 = new StringConcatenation();
                                _builder_13.append("STfunc.VAL_TO_BYTE");
                                call = _builder_13.toString();
                                break;
                            }
                            case "word_to_udint": 
                            case "word_to_ulint": 
                            case "word_to_dint": 
                            case "word_to_lint": 
                            case "word_to_uint": 
                            case "word_to_int": {
                                StringConcatenation _builder_14 = new StringConcatenation();
                                call = _builder_14.toString();
                                break;
                            }
                            case "dword_to_bool": {
                                StringConcatenation _builder_15 = new StringConcatenation();
                                _builder_15.append("STfunc.BYTE_TO_BOOL");
                                call = _builder_15.toString();
                                break;
                            }
                            case "dword_to_byte": {
                                StringConcatenation _builder_16 = new StringConcatenation();
                                _builder_16.append("STfunc.VAL_TO_BYTE");
                                call = _builder_16.toString();
                                break;
                            }
                            case "dword_to_word": {
                                StringConcatenation _builder_17 = new StringConcatenation();
                                _builder_17.append("STfunc.VAL_TO_WORD");
                                call = _builder_17.toString();
                                break;
                            }
                            case "dword_to_lword": {
                                StringConcatenation _builder_18 = new StringConcatenation();
                                call = _builder_18.toString();
                                break;
                            }
                            case "dword_to_usint": 
                            case "dword_to_sint": {
                                StringConcatenation _builder_19 = new StringConcatenation();
                                _builder_19.append("STfunc.VAL_TO_BYTE");
                                call = _builder_19.toString();
                                break;
                            }
                            case "dword_to_int": 
                            case "dword_to_uint": {
                                StringConcatenation _builder_20 = new StringConcatenation();
                                _builder_20.append("STfunc.VAL_TO_WORD");
                                call = _builder_20.toString();
                                break;
                            }
                            case "dword_to_udint": 
                            case "dword_to_ulint": 
                            case "dword_to_dint": 
                            case "dword_to_lint": 
                            case "dword_to_real": {
                                StringConcatenation _builder_21 = new StringConcatenation();
                                call = _builder_21.toString();
                                break;
                            }
                            case "lword_to_bool": {
                                StringConcatenation _builder_22 = new StringConcatenation();
                                _builder_22.append("STfunc.BYTE_TO_BOOL");
                                call = _builder_22.toString();
                                break;
                            }
                            case "lword_to_byte": {
                                StringConcatenation _builder_23 = new StringConcatenation();
                                _builder_23.append("STfunc.VAL_TO_BYTE");
                                call = _builder_23.toString();
                                break;
                            }
                            case "lword_to_word": {
                                StringConcatenation _builder_24 = new StringConcatenation();
                                _builder_24.append("STfunc.VAL_TO_WORD");
                                call = _builder_24.toString();
                                break;
                            }
                            case "lword_to_dword": {
                                StringConcatenation _builder_25 = new StringConcatenation();
                                _builder_25.append("STfunc.VAL_TO_DWORD");
                                call = _builder_25.toString();
                                break;
                            }
                            case "lword_to_sint": 
                            case "lword_to_usint": {
                                StringConcatenation _builder_26 = new StringConcatenation();
                                _builder_26.append("STfunc.VAL_TO_BYTE");
                                call = _builder_26.toString();
                                break;
                            }
                            case "lword_to_uint": 
                            case "lword_to_int": {
                                StringConcatenation _builder_27 = new StringConcatenation();
                                _builder_27.append("STfunc.VAL_TO_WORD");
                                call = _builder_27.toString();
                                break;
                            }
                            case "lword_to_dint": 
                            case "lword_to_udint": {
                                StringConcatenation _builder_28 = new StringConcatenation();
                                _builder_28.append("STfunc.VAL_TO_DWORD");
                                call = _builder_28.toString();
                                break;
                            }
                            case "lword_to_lint": 
                            case "lword_to_lreal": 
                            case "lword_to_ulint": {
                                StringConcatenation _builder_29 = new StringConcatenation();
                                call = _builder_29.toString();
                                break;
                            }
                            case "sint_to_dword": 
                            case "sint_to_lword": 
                            case "sint_to_udint": 
                            case "sint_to_ulint": 
                            case "sint_to_usint": 
                            case "sint_to_byte": 
                            case "sint_to_dint": 
                            case "sint_to_lint": 
                            case "sint_to_uint": 
                            case "sint_to_word": 
                            case "sint_to_int": {
                                StringConcatenation _builder_30 = new StringConcatenation();
                                call = _builder_30.toString();
                                break;
                            }
                            case "usint_to_int": 
                            case "usint_to_dword": 
                            case "usint_to_lword": 
                            case "usint_to_udint": 
                            case "usint_to_ulint": 
                            case "usint_to_byte": 
                            case "usint_to_dint": 
                            case "usint_to_lint": 
                            case "usint_to_sint": 
                            case "usint_to_uint": 
                            case "usint_to_word": {
                                StringConcatenation _builder_31 = new StringConcatenation();
                                call = _builder_31.toString();
                                break;
                            }
                            case "int_to_byte": {
                                StringConcatenation _builder_32 = new StringConcatenation();
                                _builder_32.append("STfunc.VAL_TO_BYTE");
                                call = _builder_32.toString();
                                break;
                            }
                            case "int_to_dint": 
                            case "int_to_lint": 
                            case "int_to_sint": 
                            case "int_to_uint": 
                            case "int_to_word": 
                            case "int_to_dword": 
                            case "int_to_lword": 
                            case "int_to_udint": 
                            case "int_to_ulint": 
                            case "int_to_usint": {
                                StringConcatenation _builder_33 = new StringConcatenation();
                                call = _builder_33.toString();
                                break;
                            }
                            case "uint_to_byte": {
                                StringConcatenation _builder_34 = new StringConcatenation();
                                _builder_34.append("STfunc.VAL_TO_BYTE");
                                call = _builder_34.toString();
                                break;
                            }
                            case "uint_to_dword": 
                            case "uint_to_lword": 
                            case "uint_to_udint": 
                            case "uint_to_ulint": 
                            case "uint_to_usint": 
                            case "uint_to_dint": 
                            case "uint_to_lint": 
                            case "uint_to_sint": 
                            case "uint_to_word": 
                            case "uint_to_int": {
                                StringConcatenation _builder_35 = new StringConcatenation();
                                call = _builder_35.toString();
                                break;
                            }
                            case "dint_to_byte": {
                                StringConcatenation _builder_36 = new StringConcatenation();
                                _builder_36.append("STfunc.VAL_TO_BYTE");
                                call = _builder_36.toString();
                                break;
                            }
                            case "dint_to_word": {
                                StringConcatenation _builder_37 = new StringConcatenation();
                                _builder_37.append("STfunc.VAL_TO_WORD");
                                call = _builder_37.toString();
                                break;
                            }
                            case "dint_to_lint": 
                            case "dint_to_real": 
                            case "dint_to_sint": 
                            case "dint_to_uint": 
                            case "dint_to_int": 
                            case "dint_to_dword": 
                            case "dint_to_lreal": 
                            case "dint_to_lword": 
                            case "dint_to_udint": 
                            case "dint_to_ulint": 
                            case "dint_to_usint": {
                                StringConcatenation _builder_38 = new StringConcatenation();
                                call = _builder_38.toString();
                                break;
                            }
                            case "udint_to_byte": {
                                StringConcatenation _builder_39 = new StringConcatenation();
                                _builder_39.append("STfunc.VAL_TO_BYTE");
                                call = _builder_39.toString();
                                break;
                            }
                            case "udint_to_word": {
                                StringConcatenation _builder_40 = new StringConcatenation();
                                _builder_40.append("STfunc.VAL_TO_WORD");
                                call = _builder_40.toString();
                                break;
                            }
                            case "udint_to_dint": 
                            case "udint_to_lint": 
                            case "udint_to_real": 
                            case "udint_to_sint": 
                            case "udint_to_uint": 
                            case "udint_to_dword": 
                            case "udint_to_lreal": 
                            case "udint_to_lword": 
                            case "udint_to_ulint": 
                            case "udint_to_usint": 
                            case "udint_to_int": {
                                StringConcatenation _builder_41 = new StringConcatenation();
                                call = _builder_41.toString();
                                break;
                            }
                            case "lint_to_byte": {
                                StringConcatenation _builder_42 = new StringConcatenation();
                                _builder_42.append("STfunc.VAL_TO_BYTE");
                                call = _builder_42.toString();
                                break;
                            }
                            case "lint_to_word": {
                                StringConcatenation _builder_43 = new StringConcatenation();
                                _builder_43.append("STfunc.VAL_TO_WORD");
                                call = _builder_43.toString();
                                break;
                            }
                            case "lint_to_dword": {
                                StringConcatenation _builder_44 = new StringConcatenation();
                                _builder_44.append("STfunc.VAL_TO_DWORD");
                                call = _builder_44.toString();
                                break;
                            }
                            case "lint_to_dint": 
                            case "lint_to_real": 
                            case "lint_to_sint": 
                            case "lint_to_uint": 
                            case "lint_to_lreal": 
                            case "lint_to_lword": 
                            case "lint_to_udint": 
                            case "lint_to_ulint": 
                            case "lint_to_usint": 
                            case "lint_to_int": {
                                StringConcatenation _builder_45 = new StringConcatenation();
                                call = _builder_45.toString();
                                break;
                            }
                            case "ulint_to_byte": {
                                StringConcatenation _builder_46 = new StringConcatenation();
                                _builder_46.append("STfunc.VAL_TO_BYTE");
                                call = _builder_46.toString();
                                break;
                            }
                            case "ulint_to_word": {
                                StringConcatenation _builder_47 = new StringConcatenation();
                                _builder_47.append("STfunc.VAL_TO_WORD");
                                call = _builder_47.toString();
                                break;
                            }
                            case "ulint_to_dword": {
                                StringConcatenation _builder_48 = new StringConcatenation();
                                _builder_48.append("STfunc.VAL_TO_DWORD");
                                call = _builder_48.toString();
                                break;
                            }
                            case "ulint_to_int": 
                            case "ulint_to_dint": 
                            case "ulint_to_lint": 
                            case "ulint_to_real": 
                            case "ulint_to_sint": 
                            case "ulint_to_uint": 
                            case "ulint_to_lreal": 
                            case "ulint_to_lword": 
                            case "ulint_to_udint": 
                            case "ulint_to_usint": {
                                StringConcatenation _builder_49 = new StringConcatenation();
                                call = _builder_49.toString();
                                break;
                            }
                            case "real_to_dword": {
                                StringConcatenation _builder_50 = new StringConcatenation();
                                call = _builder_50.toString();
                                break;
                            }
                            case "real_to_dint": 
                            case "real_to_lint": 
                            case "real_to_sint": 
                            case "real_to_uint": 
                            case "real_to_int": 
                            case "real_to_udint": 
                            case "real_to_ulint": 
                            case "real_to_usint": {
                                StringConcatenation _builder_51 = new StringConcatenation();
                                _builder_51.append("math.floor");
                                call = _builder_51.toString();
                                break;
                            }
                            case "real_to_lreal": {
                                StringConcatenation _builder_52 = new StringConcatenation();
                                call = _builder_52.toString();
                                break;
                            }
                            case "lreal_to_lword": {
                                StringConcatenation _builder_53 = new StringConcatenation();
                                call = _builder_53.toString();
                                break;
                            }
                            case "lreal_to_udint": 
                            case "lreal_to_ulint": 
                            case "lreal_to_usint": 
                            case "lreal_to_dint": 
                            case "lreal_to_lint": 
                            case "lreal_to_sint": 
                            case "lreal_to_uint": 
                            case "lreal_to_int": {
                                StringConcatenation _builder_54 = new StringConcatenation();
                                _builder_54.append("math.floor");
                                call = _builder_54.toString();
                                break;
                            }
                            case "lreal_to_real": {
                                StringConcatenation _builder_55 = new StringConcatenation();
                                call = _builder_55.toString();
                                break;
                            }
                            case "char_to_dword": 
                            case "char_to_lword": 
                            case "char_to_byte": 
                            case "char_to_word": {
                                StringConcatenation _builder_56 = new StringConcatenation();
                                _builder_56.append("string.byte");
                                call = _builder_56.toString();
                                break;
                            }
                            case "char_to_string": {
                                StringConcatenation _builder_57 = new StringConcatenation();
                                call = _builder_57.toString();
                                break;
                            }
                            case "char_to_wchar": {
                                StringConcatenation _builder_58 = new StringConcatenation();
                                _builder_58.append("STfunc.CHAR_TO_WCHAR");
                                call = _builder_58.toString();
                                break;
                            }
                            case "wchar_to_word": 
                            case "wchar_to_dword": 
                            case "wchar_to_lword": {
                                StringConcatenation _builder_59 = new StringConcatenation();
                                _builder_59.append("STfunc.WCHAR_TO_BYTE");
                                call = _builder_59.toString();
                                break;
                            }
                            case "wchar_to_wstring": {
                                StringConcatenation _builder_60 = new StringConcatenation();
                                call = _builder_60.toString();
                                break;
                            }
                            case "wchar_to_char": {
                                StringConcatenation _builder_61 = new StringConcatenation();
                                _builder_61.append("string.sub");
                                call = _builder_61.toString();
                                StringConcatenation _builder_62 = new StringConcatenation();
                                _builder_62.append(",2,2");
                                addPars = _builder_62.toString();
                                break;
                            }
                            case "string_to_char": {
                                StringConcatenation _builder_63 = new StringConcatenation();
                                _builder_63.append("string.sub");
                                call = _builder_63.toString();
                                StringConcatenation _builder_64 = new StringConcatenation();
                                _builder_64.append(",1,1");
                                addPars = _builder_64.toString();
                                break;
                            }
                            case "string_to_wstring": {
                                StringConcatenation _builder_65 = new StringConcatenation();
                                _builder_65.append("STfunc.STRING_TO_WSTRING");
                                call = _builder_65.toString();
                                break;
                            }
                            case "wstring_to_wchar": {
                                StringConcatenation _builder_66 = new StringConcatenation();
                                _builder_66.append("string.sub");
                                call = _builder_66.toString();
                                StringConcatenation _builder_67 = new StringConcatenation();
                                _builder_67.append(",1,2");
                                addPars = _builder_67.toString();
                                break;
                            }
                            case "wstring_to_string": {
                                StringConcatenation _builder_68 = new StringConcatenation();
                                _builder_68.append("STfunc.WSTRING_TO_STRING");
                                call = _builder_68.toString();
                                break;
                            }
                            case "tod_to_ltod": 
                            case "time_to_ltime": 
                            case "ldt_to_date": 
                            case "ldt_to_ltod": 
                            case "ldt_to_dt": 
                            case "ltod_to_tod": 
                            case "dt_to_date": 
                            case "dt_to_ltod": 
                            case "ltime_to_time": 
                            case "dt_to_ldt": 
                            case "dt_to_tod": 
                            case "ldt_to_tod": {
                                StringConcatenation _builder_69 = new StringConcatenation();
                                call = _builder_69.toString();
                                break;
                            }
                            default: {
                                StringConcatenation _builder_70 = new StringConcatenation();
                                CharSequence _generateFeatureName = this.generateFeatureName(expr.getFeature(), true);
                                _builder_70.append((Object)_generateFeatureName);
                                call = _builder_70.toString();
                                break;
                            }
                        }
                        break block553;
                    }
                    StringConcatenation _builder_70 = new StringConcatenation();
                    CharSequence _generateFeatureName = this.generateFeatureName(expr.getFeature(), true);
                    _builder_70.append((Object)_generateFeatureName);
                    call = _builder_70.toString();
                }
                StringConcatenation _builder_71 = new StringConcatenation();
                _builder_71.append(call);
                _builder_71.append("(");
                Iterable<CharSequence> _generateCallArguments = this.generateCallArguments(expr);
                boolean _hasElements = false;
                for (CharSequence arg : _generateCallArguments) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_71.appendImmediate((Object)", ", "");
                    }
                    _builder_71.append((Object)arg);
                }
                _builder_71.append(addPars);
                _builder_71.append(")");
                return _builder_71;
            }
            StringConcatenation _builder_72 = new StringConcatenation();
            _builder_72.append("{");
            Iterable<CharSequence> _generateReturnArguments = this.generateReturnArguments(expr);
            boolean _hasElements_1 = false;
            for (CharSequence arg_1 : _generateReturnArguments) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder_72.appendImmediate((Object)", ", "");
                }
                _builder_72.append("'");
                _builder_72.append((Object)arg_1);
                _builder_72.append("'");
            }
            _builder_72.append("}");
            String list = _builder_72.toString();
            StringConcatenation _builder_73 = new StringConcatenation();
            _builder_73.append("STfunc.wrapfunc(");
            CharSequence _generateFeatureName_1 = this.generateFeatureName(expr.getFeature(), true);
            _builder_73.append((Object)_generateFeatureName_1);
            _builder_73.append(", fb, ENV, ");
            _builder_73.append(list);
            Iterable<CharSequence> _generateCallArguments_1 = this.generateCallArguments(expr);
            boolean _hasElements_2 = false;
            for (CharSequence arg_2 : _generateCallArguments_1) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                    _builder_73.append(", ");
                } else {
                    _builder_73.appendImmediate((Object)", ", "");
                }
                _builder_73.append((Object)arg_2);
            }
            _builder_73.append(")");
            return _builder_73;
        }
        StringConcatenation _builder_74 = new StringConcatenation();
        CharSequence _generateFeatureName_2 = this.generateFeatureName(expr.getFeature(), false);
        _builder_74.append((Object)_generateFeatureName_2);
        _xblockexpression = _builder_74;
        return _xblockexpression;
    }

    protected Iterable<CharSequence> generateCallArguments(STFeatureExpression expr) {
        Iterable _xtrycatchfinallyexpression = null;
        try {
            Functions.Function1 _function = it -> this.generateInputCallArgument((INamedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map = IterableExtensions.map(expr.getMappedInputArguments().entrySet(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> this.generateInOutCallArgument((INamedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map_1 = IterableExtensions.map(expr.getMappedInOutArguments().entrySet(), (Functions.Function1)_function_1);
            _xtrycatchfinallyexpression = Iterables.concat((Iterable)_map, (Iterable)_map_1);
        }
        catch (Throwable _t) {
            if (_t instanceof IndexOutOfBoundsException) {
                List _xblockexpression = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Not enough arguments for ");
                String _name = expr.getFeature().getName();
                _builder.append(_name);
                this.errors.add(_builder.toString());
                _xblockexpression = CollectionLiterals.emptyList();
                _xtrycatchfinallyexpression = _xblockexpression;
            }
            if (_t instanceof ClassCastException) {
                List _xblockexpression_1 = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mixing named and unnamed arguments is not allowed");
                this.errors.add(_builder.toString());
                _xblockexpression_1 = CollectionLiterals.emptyList();
                _xtrycatchfinallyexpression = _xblockexpression_1;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected Iterable<CharSequence> generateReturnArguments(STFeatureExpression expr) {
        Iterable _xtrycatchfinallyexpression = null;
        try {
            Functions.Function1 _function = it -> this.generateOutputReturnArgument((INamedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map = IterableExtensions.map(expr.getMappedInOutArguments().entrySet(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> this.generateOutputReturnArgument((INamedElement)it.getKey(), (STCallArgument)it.getValue());
            Iterable _map_1 = IterableExtensions.map(expr.getMappedOutputArguments().entrySet(), (Functions.Function1)_function_1);
            _xtrycatchfinallyexpression = Iterables.concat((Iterable)_map, (Iterable)_map_1);
        }
        catch (Throwable _t) {
            if (_t instanceof IndexOutOfBoundsException) {
                List _xblockexpression = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Not enough arguments for ");
                String _name = expr.getFeature().getName();
                _builder.append(_name);
                this.errors.add(_builder.toString());
                _xblockexpression = CollectionLiterals.emptyList();
                _xtrycatchfinallyexpression = _xblockexpression;
            }
            if (_t instanceof ClassCastException) {
                List _xblockexpression_1 = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mixing named and unnamed arguments is not allowed");
                this.errors.add(_builder.toString());
                _xblockexpression_1 = CollectionLiterals.emptyList();
                _xtrycatchfinallyexpression = _xblockexpression_1;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected CharSequence generateInputCallArgument(INamedElement parameter, STCallArgument argument) {
        CharSequence _xifexpression = null;
        _xifexpression = argument == null ? this.generateVariableDefaultValue(parameter) : this.generateExpression(argument.getArgument());
        return _xifexpression;
    }

    protected CharSequence generateInOutCallArgument(INamedElement parameter, STCallArgument argument) {
        CharSequence _xifexpression = null;
        if (argument == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("nil");
            _xifexpression = _builder;
        } else {
            _xifexpression = this.generateExpression(argument.getArgument());
        }
        return _xifexpression;
    }

    protected CharSequence generateOutputReturnArgument(INamedElement parameter, STCallArgument argument) {
        CharSequence _xifexpression = null;
        if (argument == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("nil");
            _xifexpression = _builder;
        } else {
            _xifexpression = this.generateOutputExpression(argument.getArgument());
        }
        return _xifexpression;
    }

    protected CharSequence _generateOutputExpression(STExpression expr) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The expression ");
        String _name = expr.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported as an out parameter");
        this.errors.add(_builder.toString());
        _xblockexpression = "";
        return _xblockexpression;
    }

    protected CharSequence _generateOutputExpression(STFeatureExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateOutputFeatureName = this.generateOutputFeatureName(expr.getFeature());
        _builder.append((Object)_generateOutputFeatureName);
        return _builder;
    }

    protected CharSequence _generateOutputFeatureName(INamedElement feature) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The feature ");
        String _name = feature.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported as an out parameter");
        this.errors.add(_builder.toString());
        _xblockexpression = "";
        return _xblockexpression;
    }

    protected CharSequence _generateOutputFeatureName(VarDeclaration feature) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("fb_var_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateOutputFeatureName(STVarDeclaration feature) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("st_lv_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateExpression(STNumericLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        Object _value = expr.getValue();
        _builder.append(_value);
        return _builder;
    }

    protected CharSequence _generateExpression(STStringLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _convertToJavaString = Strings.convertToJavaString((String)expr.getValue().toString());
        _builder.append(_convertToJavaString);
        _builder.append("\"");
        return _builder;
    }

    protected CharSequence _generateExpression(STDateLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _epochSecond = expr.getValue().toEpochSecond(LocalTime.MIDNIGHT, ZoneOffset.UTC);
        long _multiply = _epochSecond * 1000000000L;
        _builder.append((Object)_multiply);
        return _builder;
    }

    protected CharSequence _generateExpression(STTimeLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _nanos = expr.getValue().toNanos();
        _builder.append((Object)_nanos);
        return _builder;
    }

    protected CharSequence _generateExpression(STTimeOfDayLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _nanoOfDay = expr.getValue().toNanoOfDay();
        _builder.append((Object)_nanoOfDay);
        return _builder;
    }

    protected CharSequence _generateExpression(STDateAndTimeLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        long _until = LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC).until(expr.getValue(), ChronoUnit.NANOS);
        _builder.append((Object)_until);
        return _builder;
    }

    protected CharSequence _generateTemplateExpression(STBinaryExpression expr) {
        StringConcatenation _switchResult = null;
        STBinaryOperator _op = expr.getOp();
        if (_op != null) {
            switch (_op) {
                case RANGE: {
                    StringConcatenation _builder = new StringConcatenation();
                    CharSequence _generateTemplateExpression = this.generateTemplateExpression(expr.getLeft());
                    _builder.append((Object)_generateTemplateExpression);
                    _builder.append(", ");
                    CharSequence _generateTemplateExpression_1 = this.generateTemplateExpression(expr.getRight());
                    _builder.append((Object)_generateTemplateExpression_1);
                    _switchResult = _builder;
                    break;
                }
                case AMPERSAND: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("AND(");
                    CharSequence _generateTemplateExpression_2 = this.generateTemplateExpression(expr.getLeft());
                    _builder_1.append((Object)_generateTemplateExpression_2);
                    _builder_1.append(", ");
                    CharSequence _generateTemplateExpression_3 = this.generateTemplateExpression(expr.getRight());
                    _builder_1.append((Object)_generateTemplateExpression_3);
                    _builder_1.append(")");
                    _switchResult = _builder_1;
                    break;
                }
                default: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _name = expr.getOp().getName();
                    _builder_2.append(_name);
                    _builder_2.append("(");
                    CharSequence _generateTemplateExpression_4 = this.generateTemplateExpression(expr.getLeft());
                    _builder_2.append((Object)_generateTemplateExpression_4);
                    _builder_2.append(", ");
                    CharSequence _generateTemplateExpression_5 = this.generateTemplateExpression(expr.getRight());
                    _builder_2.append((Object)_generateTemplateExpression_5);
                    _builder_2.append(")");
                    _switchResult = _builder_2;
                    break;
                }
            }
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            String _name = expr.getOp().getName();
            _builder_2.append(_name);
            _builder_2.append("(");
            CharSequence _generateTemplateExpression_4 = this.generateTemplateExpression(expr.getLeft());
            _builder_2.append((Object)_generateTemplateExpression_4);
            _builder_2.append(", ");
            CharSequence _generateTemplateExpression_5 = this.generateTemplateExpression(expr.getRight());
            _builder_2.append((Object)_generateTemplateExpression_5);
            _builder_2.append(")");
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    protected CharSequence _generateTemplateExpression(STUnaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = expr.getOp().getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _generateTemplateExpression = this.generateTemplateExpression(expr.getExpression());
        _builder.append((Object)_generateTemplateExpression);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateTemplateExpression(STNumericLiteral expr) {
        return expr.getValue().toString();
    }

    protected CharSequence _generateVariableDefaultValue(INamedElement feature) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The variable ");
        String _name = feature.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        _xblockexpression = "0";
        return _xblockexpression;
    }

    protected CharSequence _generateVariableDefaultValue(VarDeclaration variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("nil");
        return _builder;
    }

    protected CharSequence _generateVariableDefaultValue(STVarDeclaration variable) {
        boolean _tripleNotEquals;
        CharSequence _xifexpression = null;
        STInitializerExpression _defaultValue = variable.getDefaultValue();
        boolean bl = _tripleNotEquals = _defaultValue != null;
        if (_tripleNotEquals) {
            _xifexpression = this.generateInitializerExpression(variable.getDefaultValue());
        } else {
            CharSequence _xifexpression_1 = null;
            boolean _isArray = variable.isArray();
            if (_isArray) {
                _xifexpression_1 = "{lo=0, up=0}";
            } else {
                INamedElement _type = variable.getType();
                _xifexpression_1 = StructuredTextSupport.generateTypeDefaultValue((DataType)_type);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected CharSequence _generateFeatureName(INamedElement feature, boolean call) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The feature ");
        String _name = feature.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        _xblockexpression = "";
        return _xblockexpression;
    }

    protected CharSequence _generateFeatureName(VarDeclaration feature, boolean call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ENV.fb_var_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(STVarDeclaration feature, boolean call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ENV.st_lv_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(STFunction feature, boolean call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("func_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(STStandardFunction feature, boolean call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("STfunc.");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(STMethod feature, boolean call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("method_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateFeatureName(FB feature, boolean call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("fb_");
        String _name = feature.getName();
        _builder.append(_name);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _generateFeatureName(Event feature, boolean call) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("evt_");
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    protected INamedElement _getType(INamedElement feature) {
        Object _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The feature ");
        String _name = feature.eClass().getName();
        _builder.append(_name);
        _builder.append(" is not supported");
        this.errors.add(_builder.toString());
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected INamedElement _getType(VarDeclaration feature) {
        return feature.getType();
    }

    protected INamedElement _getType(STVarDeclaration feature) {
        return feature.getType();
    }

    protected int getIntegerFromConstantExpression(STExpression expr) {
        int _xtrycatchfinallyexpression = 0;
        try {
            Object _value = ((STNumericLiteral)expr).getValue();
            _xtrycatchfinallyexpression = ((BigDecimal)_value).intValueExact();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                int _xblockexpression = 0;
                this.errors.add("Not a constant integer expression");
                _xtrycatchfinallyexpression = _xblockexpression = 1;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected Set<INamedElement> getContainedDependencies(EObject object) {
        Functions.Function1 _function = it -> this.getDependencies((EObject)it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IteratorExtensions.toIterable((Iterator)EcoreUtil.getAllProperContents((EObject)object, (boolean)true)), (Functions.Function1)_function));
    }

    protected Iterable<INamedElement> getDependencies(EObject object) {
        INamedElement _resultType;
        INamedElement _type;
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (object instanceof STVarDeclaration) {
            _matched = true;
            _type = ((STVarDeclaration)object).getType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_type}));
        }
        if (!_matched && object instanceof STNumericLiteral) {
            _matched = true;
            _resultType = ((STNumericLiteral)object).getResultType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_resultType}));
        }
        if (!_matched && object instanceof STStringLiteral) {
            _matched = true;
            _resultType = ((STStringLiteral)object).getResultType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_resultType}));
        }
        if (!_matched && object instanceof STDateLiteral) {
            _matched = true;
            _type = ((STDateLiteral)object).getType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_type}));
        }
        if (!_matched && object instanceof STTimeLiteral) {
            _matched = true;
            _type = ((STTimeLiteral)object).getType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_type}));
        }
        if (!_matched && object instanceof STTimeOfDayLiteral) {
            _matched = true;
            _type = ((STTimeOfDayLiteral)object).getType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_type}));
        }
        if (!_matched && object instanceof STDateAndTimeLiteral) {
            _matched = true;
            _type = ((STDateAndTimeLiteral)object).getType();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_type}));
        }
        if (!_matched && object instanceof STFeatureExpression) {
            _matched = true;
            _switchResult = this.getDependencies((EObject)((STFeatureExpression)object).getFeature());
        }
        if (!_matched && object instanceof STFunction) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{(INamedElement)object}));
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptySet();
        }
        return _switchResult;
    }

    protected CharSequence generateUniqueVariableName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("st_lv_synthetic_");
        int _plusPlus = this.uniqueVariableIndex++;
        _builder.append((Object)_plusPlus);
        return _builder;
    }

    public static CharSequence generateVarDefaultValue(VarDeclaration decl) {
        boolean _isNullOrEmpty;
        CharSequence _xifexpression = null;
        Value _value = decl.getValue();
        String _value_1 = null;
        if (_value != null) {
            _value_1 = _value.getValue();
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_1)) {
            _xifexpression = StructuredTextSupport.generateTypeDefaultValue(decl.getType());
        } else {
            Object _switchResult;
            StringConcatenation _builder;
            StringConcatenation _xblockexpression_1;
            StringConcatenation _xblockexpression = null;
            ValueConverter converter = ValueConverterFactory.createValueConverter((DataType)decl.getType());
            StringConcatenation _xifexpression_1 = null;
            if (converter != null) {
                _xblockexpression_1 = null;
                Object value = converter.toValue(decl.getValue().getValue());
                _builder = new StringConcatenation();
                CharSequence _generateTypeName = StructuredTextSupport.generateTypeName(decl.getType());
                _builder.append((Object)_generateTypeName);
                _builder.append("(");
                _switchResult = null;
                boolean _matched = false;
                if (value instanceof String) {
                    _matched = true;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("\"");
                    String _convertToJavaString = Strings.convertToJavaString((String)((String)value));
                    _builder_1.append(_convertToJavaString);
                    _builder_1.append("\"");
                    _switchResult = _builder_1;
                }
                if (!_matched && value instanceof Duration) {
                    _matched = true;
                    _switchResult = Long.toString(((Duration)value).toNanos());
                }
                if (!_matched && value instanceof LocalTime) {
                    _matched = true;
                    _switchResult = Long.toString(((LocalTime)value).toNanoOfDay());
                }
                if (!_matched && value instanceof LocalDate) {
                    _matched = true;
                    long _epochSecond = ((LocalDate)value).toEpochSecond(LocalTime.MIDNIGHT, ZoneOffset.UTC);
                    long _multiply = _epochSecond * 1000000000L;
                    _switchResult = Long.toString(_multiply);
                }
                if (!_matched && value instanceof LocalDateTime) {
                    _matched = true;
                    _switchResult = Long.toString(LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC).until((Temporal)value, ChronoUnit.NANOS));
                }
                if (!_matched) {
                    _switchResult = value;
                }
            } else {
                DataType _type = decl.getType();
                String _name = null;
                if (_type != null) {
                    _name = _type.getName();
                }
                String _plus = "No value converter for type " + _name;
                throw new UnsupportedOperationException(_plus);
            }
            _builder.append(_switchResult);
            _builder.append(")");
            _xifexpression_1 = _xblockexpression_1 = _builder;
            _xblockexpression = _xifexpression_1;
            _xifexpression = _xblockexpression;
        }
        return _xifexpression;
    }

    public static CharSequence generateTypeDefaultValue(DataType type) {
        StringConcatenation _builder;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (type instanceof AnyStringType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("\"\"");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof BoolType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("false");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof AnyElementaryType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("0");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("{lo=0, up=0}");
            _switchResult = _builder;
        }
        if (!_matched && type instanceof StructuredType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("{}");
            _switchResult = _builder;
        }
        if (!_matched) {
            _builder = new StringConcatenation();
            _builder.append("0");
            _switchResult = _builder;
        }
        return _switchResult;
    }

    public static CharSequence generateTypeName(DataType type) {
        String _switchResult = null;
        boolean _matched = false;
        if (type instanceof TimeType) {
            _matched = true;
        }
        if (!_matched && type instanceof LtimeType) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = "CIEC_TIME";
        }
        if (!_matched) {
            if (type instanceof DateType) {
                _matched = true;
            }
            if (!_matched && type instanceof LdateType) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = "CIEC_DATE";
            }
        }
        if (!_matched) {
            if (type instanceof TimeOfDayType) {
                _matched = true;
            }
            if (!_matched && type instanceof LtodType) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = "CIEC_TIME_OF_DAY";
            }
        }
        if (!_matched) {
            if (type instanceof DateAndTimeType) {
                _matched = true;
            }
            if (!_matched && type instanceof LdtType) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = "CIEC_DATE_AND_TIME";
            }
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            _switchResult = "CIEC_ARRAY";
        }
        if (!_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("CIEC_");
            String _name = type.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        return _switchResult;
    }

    @XbaseGenerated
    protected CharSequence generateInitializerExpression(STInitializerExpression expr) {
        if (expr instanceof STArrayInitializerExpression) {
            return this._generateInitializerExpression((STArrayInitializerExpression)expr);
        }
        if (expr instanceof STElementaryInitializerExpression) {
            return this._generateInitializerExpression((STElementaryInitializerExpression)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    @XbaseGenerated
    protected CharSequence generateArrayInitElement(STArrayInitElement elem) {
        if (elem instanceof STRepeatArrayInitElement) {
            return this._generateArrayInitElement((STRepeatArrayInitElement)elem);
        }
        if (elem instanceof STSingleArrayInitElement) {
            return this._generateArrayInitElement((STSingleArrayInitElement)elem);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(elem).toString());
    }

    @XbaseGenerated
    protected CharSequence generateStatement(STStatement stmt) {
        if (stmt instanceof STCaseStatement) {
            return this._generateStatement((STCaseStatement)stmt);
        }
        if (stmt instanceof STContinue) {
            return this._generateStatement((STContinue)stmt);
        }
        if (stmt instanceof STExit) {
            return this._generateStatement((STExit)stmt);
        }
        if (stmt instanceof STExpression) {
            return this._generateStatement((STExpression)stmt);
        }
        if (stmt instanceof STForStatement) {
            return this._generateStatement((STForStatement)stmt);
        }
        if (stmt instanceof STIfStatement) {
            return this._generateStatement((STIfStatement)stmt);
        }
        if (stmt instanceof STNop) {
            return this._generateStatement((STNop)stmt);
        }
        if (stmt instanceof STRepeatStatement) {
            return this._generateStatement((STRepeatStatement)stmt);
        }
        if (stmt instanceof STReturn) {
            return this._generateStatement((STReturn)stmt);
        }
        if (stmt instanceof STWhileStatement) {
            return this._generateStatement((STWhileStatement)stmt);
        }
        if (stmt != null) {
            return this._generateStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    @XbaseGenerated
    protected CharSequence generateExpression(STExpression expr) {
        if (expr instanceof STArrayAccessExpression) {
            return this._generateExpression((STArrayAccessExpression)expr);
        }
        if (expr instanceof STAssignment) {
            return this._generateExpression((STAssignment)expr);
        }
        if (expr instanceof STBinaryExpression) {
            return this._generateExpression((STBinaryExpression)expr);
        }
        if (expr instanceof STDateAndTimeLiteral) {
            return this._generateExpression((STDateAndTimeLiteral)expr);
        }
        if (expr instanceof STDateLiteral) {
            return this._generateExpression((STDateLiteral)expr);
        }
        if (expr instanceof STFeatureExpression) {
            return this._generateExpression((STFeatureExpression)expr);
        }
        if (expr instanceof STMemberAccessExpression) {
            return this._generateExpression((STMemberAccessExpression)expr);
        }
        if (expr instanceof STNumericLiteral) {
            return this._generateExpression((STNumericLiteral)expr);
        }
        if (expr instanceof STStringLiteral) {
            return this._generateExpression((STStringLiteral)expr);
        }
        if (expr instanceof STTimeLiteral) {
            return this._generateExpression((STTimeLiteral)expr);
        }
        if (expr instanceof STTimeOfDayLiteral) {
            return this._generateExpression((STTimeOfDayLiteral)expr);
        }
        if (expr instanceof STUnaryExpression) {
            return this._generateExpression((STUnaryExpression)expr);
        }
        if (expr != null) {
            return this._generateExpression(expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    @XbaseGenerated
    protected CharSequence generateOutputExpression(STExpression expr) {
        if (expr instanceof STFeatureExpression) {
            return this._generateOutputExpression((STFeatureExpression)expr);
        }
        if (expr != null) {
            return this._generateOutputExpression(expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    @XbaseGenerated
    protected CharSequence generateOutputFeatureName(INamedElement feature) {
        if (feature instanceof VarDeclaration) {
            return this._generateOutputFeatureName((VarDeclaration)feature);
        }
        if (feature instanceof STVarDeclaration) {
            return this._generateOutputFeatureName((STVarDeclaration)feature);
        }
        if (feature != null) {
            return this._generateOutputFeatureName(feature);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(feature).toString());
    }

    @XbaseGenerated
    protected CharSequence generateTemplateExpression(STExpression expr) {
        if (expr instanceof STBinaryExpression) {
            return this._generateTemplateExpression((STBinaryExpression)expr);
        }
        if (expr instanceof STNumericLiteral) {
            return this._generateTemplateExpression((STNumericLiteral)expr);
        }
        if (expr instanceof STUnaryExpression) {
            return this._generateTemplateExpression((STUnaryExpression)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    @XbaseGenerated
    protected CharSequence generateVariableDefaultValue(INamedElement variable) {
        if (variable instanceof VarDeclaration) {
            return this._generateVariableDefaultValue((VarDeclaration)variable);
        }
        if (variable instanceof STVarDeclaration) {
            return this._generateVariableDefaultValue((STVarDeclaration)variable);
        }
        if (variable != null) {
            return this._generateVariableDefaultValue(variable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable).toString());
    }

    @XbaseGenerated
    protected CharSequence generateFeatureName(INamedElement feature, boolean call) {
        if (feature instanceof FB) {
            return this._generateFeatureName((FB)feature, call);
        }
        if (feature instanceof Event) {
            return this._generateFeatureName((Event)feature, call);
        }
        if (feature instanceof VarDeclaration) {
            return this._generateFeatureName((VarDeclaration)feature, call);
        }
        if (feature instanceof STMethod) {
            return this._generateFeatureName((STMethod)feature, call);
        }
        if (feature instanceof STStandardFunction) {
            return this._generateFeatureName((STStandardFunction)feature, call);
        }
        if (feature instanceof STVarDeclaration) {
            return this._generateFeatureName((STVarDeclaration)feature, call);
        }
        if (feature instanceof STFunction) {
            return this._generateFeatureName((STFunction)feature, call);
        }
        if (feature != null) {
            return this._generateFeatureName(feature, call);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(feature, call).toString());
    }

    @XbaseGenerated
    protected INamedElement getType(INamedElement feature) {
        if (feature instanceof VarDeclaration) {
            return this._getType((VarDeclaration)feature);
        }
        if (feature instanceof STVarDeclaration) {
            return this._getType((STVarDeclaration)feature);
        }
        if (feature != null) {
            return this._getType(feature);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(feature).toString());
    }

    @Pure
    public List<String> getErrors() {
        return this.errors;
    }

    @Pure
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Pure
    public List<String> getInfos() {
        return this.infos;
    }
}

