/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.breakpoint;

import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.gef.dialogs.VariableDialog;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;

public class DeploymentWatchpointForceEditor {
    public static final int PROP_FORCE_VALUE = 1;
    public static final int PROP_FORCE_ENABLED = 2;
    private final ListenerList<IPropertyListener> listeners = new ListenerList();
    private DeploymentWatchpoint input;
    private VarDeclaration varDeclaration;
    private Control control;
    private Button forceCheckbox;
    private Text forceText;
    private Button dialogButton;
    private boolean dirty;
    private boolean suppressPropertyChanges;

    public Control createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        this.forceCheckbox = new Button(comp, 32);
        this.forceCheckbox.setText(Messages.DeploymentWatchpointForceEditor_ForceLabel);
        this.forceCheckbox.setEnabled(false);
        this.forceCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.forceText != null) {
                this.forceText.setEditable(this.input != null && this.forceCheckbox.getSelection());
            }
            this.firePropertyChange(2);
            this.setDirty(true);
        }));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.forceCheckbox);
        Control forceEditor = this.createForceEditor(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(forceEditor);
        this.control = comp;
        return comp;
    }

    protected Control createForceEditor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.forceText = new Text(composite, 2052);
        this.forceText.setEditable(false);
        this.forceText.addModifyListener(event -> {
            this.firePropertyChange(1);
            this.setDirty(true);
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.forceText);
        this.dialogButton = new Button(composite, 0x800000);
        this.dialogButton.setText("\u2026");
        this.dialogButton.setEnabled(false);
        this.dialogButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.openDialog()));
        GridDataFactory.swtDefaults().applyTo((Control)this.dialogButton);
        return composite;
    }

    protected void openDialog() {
        try {
            VariableDialog.open((Shell)this.control.getShell(), (ITypedElement)this.varDeclaration, (String)this.forceText.getText()).ifPresent(arg_0 -> ((Text)this.forceText).setText(arg_0));
        }
        finally {
            this.forceText.forceFocus();
        }
    }

    private boolean isStructuredVariable() {
        return this.varDeclaration != null && (this.varDeclaration.isArray() || this.varDeclaration.getType() instanceof StructuredType);
    }

    public void setInput(DeploymentWatchpoint input) {
        try {
            this.suppressPropertyChanges = true;
            this.input = input;
            this.varDeclaration = Optional.ofNullable(input).filter(DeploymentWatchpoint::isForceSupported).flatMap(DeploymentWatchpoint::getTarget).filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast).orElse(null);
            this.forceCheckbox.setEnabled(input != null && input.isForceSupported());
            this.forceCheckbox.setSelection(input != null && input.isForceEnabled());
            this.forceText.setEditable(input != null && input.isForceEnabled());
            this.forceText.setText(input != null ? input.getForceValue() : "");
            this.dialogButton.setEnabled(input != null && this.isStructuredVariable());
            this.setDirty(false);
        }
        finally {
            this.suppressPropertyChanges = false;
        }
    }

    public void doSave() {
        try {
            if (this.input != null && this.input.getMarker() != null && this.input.getMarker().exists()) {
                this.input.setForceEnabled(this.forceCheckbox.getSelection());
                this.input.setForceValue(this.forceText.getText());
            }
            this.setDirty(false);
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)("Couldn't set breakpoint condition on " + String.valueOf(this.input)), (Throwable)e);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (dirty != this.dirty) {
            this.dirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean setFocus() {
        return this.forceText.setFocus();
    }

    public void dispose() {
        this.listeners.clear();
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void firePropertyChange(int property) {
        if (!this.suppressPropertyChanges) {
            for (IPropertyListener listener : this.listeners) {
                listener.propertyChanged((Object)this, property);
            }
        }
    }
}

