/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.contracts.ContractElementDialog;
import org.eclipse.fordiac.ide.contracts.DefineFBDecisionTwoPinDialog;
import org.eclipse.fordiac.ide.contracts.Messages;
import org.eclipse.fordiac.ide.contracts.UpdateContractCommand;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractUtils;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class DefineFbInterfaceConstraintHandler
extends AbstractHandler {
    public static final int DEFAULT_TIME = 10;
    private static final int DEFAULT_OFFSET = 0;
    private static final int CANCEL = -1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Event> eventPins = DefineFbInterfaceConstraintHandler.getSelectedPins(event);
        ArrayList<Event> iPins = new ArrayList<Event>();
        ArrayList<Event> oPins = new ArrayList<Event>();
        for (Event pin : eventPins) {
            if (pin.isIsInput()) {
                iPins.add(pin);
                continue;
            }
            oPins.add(pin);
        }
        if (iPins.size() != 1 || oPins.size() > 2) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.DefineFbInterfaceConstraintHandler_Title, (String)Messages.DefineFbInterfaceConstraintHandler_Info);
            return Status.CANCEL_STATUS;
        }
        Event iPin = (Event)iPins.get(0);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (oPins.size() == 2) {
            DefineFbInterfaceConstraintHandler.makeThreePinReaction(shell, iPin, oPins);
        } else if (oPins.size() == 1) {
            DefineFBDecisionTwoPinDialog dialog = new DefineFBDecisionTwoPinDialog(shell);
            dialog.open();
            if (dialog.isReaction()) {
                DefineFbInterfaceConstraintHandler.makeTwoPinReaction(shell, iPin, (Event)oPins.get(0));
            } else if (dialog.isGuarantee()) {
                DefineFbInterfaceConstraintHandler.makeTwoPinGuarantee(shell, iPin, (Event)oPins.get(0));
            }
        } else {
            DefineFbInterfaceConstraintHandler.makeOnePinConstraint(shell, iPin);
        }
        return Status.OK_STATUS;
    }

    private static void makeThreePinReaction(Shell shell, Event iPin, List<Event> oPins) {
        String suggestion = ContractUtils.createGuaranteeTwoEvents(iPin.getName(), oPins.get(0).getName(), oPins.get(1).getName(), String.valueOf(10));
        DefineFbInterfaceConstraintHandler.openDialog(shell, iPin, suggestion);
    }

    private static void makeTwoPinReaction(Shell shell, Event iPin, Event oPin) {
        String suggestion = ContractUtils.createReactionString(iPin.getName(), oPin.getName(), String.valueOf(10));
        DefineFbInterfaceConstraintHandler.openDialog(shell, iPin, suggestion);
    }

    private static void makeTwoPinGuarantee(Shell shell, Event iPin, Event oPin) {
        String suggestion = ContractUtils.createGuaranteeString(iPin.getName(), oPin.getName(), String.valueOf(10));
        DefineFbInterfaceConstraintHandler.openDialog(shell, iPin, suggestion);
    }

    private static void makeOnePinConstraint(Shell shell, Event iPin) {
        StringBuilder suggestion = new StringBuilder();
        suggestion.append(ContractUtils.createAssumptionString(iPin.getName(), String.valueOf(10)));
        suggestion.append(" ");
        suggestion.append(ContractUtils.createOffsetString(String.valueOf(0)));
        DefineFbInterfaceConstraintHandler.openDialog(shell, iPin, suggestion.toString());
    }

    private static void openDialog(Shell shell, Event pin, String suggestion) {
        ContractElementDialog dialog = new ContractElementDialog(shell, suggestion);
        if (dialog.open() != -1) {
            String rule = dialog.getContractRule();
            FBNetworkElement element = pin.getFBNetworkElement();
            UpdateContractCommand uccmd = new UpdateContractCommand(element, rule);
            if (uccmd.canExecute()) {
                uccmd.execute();
            }
        }
    }

    private static List<Event> getSelectedPins(ExecutionEvent event) {
        ArrayList<Event> pins = new ArrayList<Event>();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Iterator iterator = selection.toList().iterator();
        while (iterator.hasNext()) {
            Object selected;
            Object obj = selected = iterator.next();
            if (selected instanceof EditPart) {
                EditPart selectedEP = (EditPart)selected;
                obj = selectedEP.getModel();
            }
            if (!(obj instanceof Event)) continue;
            Event eventPin = (Event)obj;
            pins.add(eventPin);
        }
        boolean sameFb = pins.stream().filter(ev -> ev.getFBNetworkElement() != null).allMatch(ev -> ev.getFBNetworkElement().equals(((Event)pins.get(0)).getFBNetworkElement()));
        if (sameFb) {
            return pins;
        }
        return Collections.emptyList();
    }
}

