/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.InterruptedIOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import org.apache.sshd.common.future.AbstractSshFuture;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class DefaultSshFuture<T extends SshFuture<T>>
extends AbstractSshFuture<T> {
    private final Object lock;
    private Object listeners;
    private Object result;

    public DefaultSshFuture(Object id, Object lock) {
        super(id);
        this.lock = lock != null ? lock : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected Object await0(long timeoutMillis, boolean interruptable, CancelOption ... options) throws InterruptedIOException {
        boolean canceled;
        long endTime;
        long curTime;
        long startTime;
        block12: {
            ValidateUtils.checkTrue(timeoutMillis >= 0L, "Negative timeout N/A: %d", timeoutMillis);
            curTime = startTime = System.currentTimeMillis();
            endTime = Long.MAX_VALUE - timeoutMillis < curTime ? Long.MAX_VALUE : curTime + timeoutMillis;
            canceled = false;
            try {
                Object object = this.lock;
                // MONITORENTER : object
                if (this.result != null) {
                    Object object2 = this.result;
                    // MONITOREXIT : object
                    if (!canceled) return object2;
                    this.notifyListeners();
                    return object2;
                }
                if (timeoutMillis > 0L) break block12;
                this.result = this.cancelOnTimeout(timeoutMillis, options);
                canceled = this.result != null;
            }
            catch (Throwable throwable) {
                if (!canceled) throw throwable;
                this.notifyListeners();
                throw throwable;
            }
            Object var13_10 = null;
            // MONITOREXIT : object
            if (!canceled) return var13_10;
            this.notifyListeners();
            return var13_10;
        }
        do {
            block13: {
                try {
                    this.lock.wait(endTime - curTime);
                }
                catch (InterruptedException e) {
                    if (!interruptable) break block13;
                    curTime = System.currentTimeMillis();
                    InterruptedIOException interrupted = this.formatExceptionMessage(msg -> {
                        InterruptedIOException exc = new InterruptedIOException((String)msg);
                        exc.initCause(e);
                        return exc;
                    }, "Interrupted after %d msec.", curTime - startTime);
                    if (this.result != null) throw interrupted;
                    if (!Arrays.asList(options).contains((Object)CancelOption.CANCEL_ON_INTERRUPT)) throw interrupted;
                    CancelFuture future = this.createCancellation();
                    if (future == null) throw interrupted;
                    CancellationException cancellation = new CancellationException("Canceled on interrupt");
                    cancellation.initCause(interrupted);
                    future.setBackTrace(cancellation);
                    this.result = future;
                    canceled = true;
                    throw interrupted;
                }
            }
            if (this.result == null) continue;
            Object object = this.result;
            // MONITOREXIT : object
            if (!canceled) return object;
            this.notifyListeners();
            return object;
        } while ((curTime = System.currentTimeMillis()) < endTime);
        this.result = this.cancelOnTimeout(timeoutMillis, options);
        canceled = this.result != null;
        Object var13_13 = null;
        // MONITOREXIT : object
        if (!canceled) return var13_13;
        this.notifyListeners();
        return var13_13;
    }

    private CancelFuture cancelOnTimeout(long timeoutMillis, CancelOption ... options) {
        CancelFuture future;
        if (Arrays.asList(options).contains((Object)CancelOption.CANCEL_ON_TIMEOUT) && (future = this.createCancellation()) != null) {
            TimeoutException cause = new TimeoutException("Timed out after " + timeoutMillis + "msec");
            CancellationException cancellation = new CancellationException(cause.getMessage());
            cancellation.initCause(cause);
            future.setBackTrace(cancellation);
            return future;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.result != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                return;
            }
            this.result = newValue != null ? newValue : GenericUtils.NULL;
            this.onValueSet(newValue);
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRegisteredListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners == null) {
                return 0;
            }
            if (this.listeners instanceof SshFutureListener) {
                return 1;
            }
            int l = Array.getLength(this.listeners);
            int count = 0;
            for (int i = 0; i < l; ++i) {
                if (Array.get(this.listeners, i) == null) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result == GenericUtils.NULL ? null : this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T addListener(SshFutureListener<T> listener) {
        Objects.requireNonNull(listener, "Missing listener argument");
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                notifyNow = true;
            } else if (this.listeners == null) {
                this.listeners = listener;
            } else if (this.listeners instanceof SshFutureListener) {
                this.listeners = new Object[]{this.listeners, listener};
            } else {
                Object[] ol = (Object[])this.listeners;
                int l = ol.length;
                Object[] nl = new Object[l + 1];
                System.arraycopy(ol, 0, nl, 0, l);
                nl[l] = listener;
                this.listeners = nl;
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
        return this.asT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeListener(SshFutureListener<T> listener) {
        Objects.requireNonNull(listener, "No listener provided");
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                return this.asT();
            }
            if (this.listeners == null) {
                return this.asT();
            }
            if (this.listeners == listener) {
                this.listeners = null;
            } else if (!(this.listeners instanceof SshFutureListener)) {
                int l = Array.getLength(this.listeners);
                for (int i = 0; i < l; ++i) {
                    if (Array.get(this.listeners, i) != listener) continue;
                    Array.set(this.listeners, i, null);
                    break;
                }
            }
        }
        return this.asT();
    }

    protected void notifyListeners() {
        if (this.listeners != null) {
            if (this.listeners instanceof SshFutureListener) {
                this.notifyListener(this.asListener(this.listeners));
            } else {
                int l = Array.getLength(this.listeners);
                for (int i = 0; i < l; ++i) {
                    SshFutureListener listener = this.asListener(Array.get(this.listeners, i));
                    if (listener == null) continue;
                    this.notifyListener(listener);
                }
            }
        }
    }

    protected CancelFuture createCancellation() {
        return null;
    }

    protected void onValueSet(Object value) {
    }

    @Override
    public String toString() {
        return super.toString() + "[value=" + this.result + "]";
    }
}

