// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2004  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                           

#ifndef __ACDeps_h__
#define __ACDeps_h__

#include "Puma/ErrorStream.h"
#include <filesystem>
#include <vector>
#include <regex>
#include <tuple>
#include <set>
#include <map>
#include <list>

class ACDeps {

  std::vector<std::tuple<std::regex, std::string>> rules_;
  std::set<std::filesystem::path> ah_canonicals_;
  std::map<std::string, std::regex> ah_deps_;
  std::set<std::string> ah_unknown_;

public:

  // load and aspect dependency file and store the rules
  bool merge_file(const std::filesystem::path &dep_file_path, Puma::ErrorStream &err);

  // after the rules have been loaded an aspect header can be registered
  // => a regular expression for checking whether some file depends on the aspect is formed
  bool register_aspect_header(const std::string &ah_file, Puma::ErrorStream &err);

  // returns the list of registered aspect headers in 'ah_files'
  enum HeaderFilter { WITHOUT_RULE = 1, WITH_RULE = 2, ALL_ASPECT_HEADERS = 3 }; // bitmap
  void get_aspect_headers(std::list<std::string> &ah_files, HeaderFilter hf = ALL_ASPECT_HEADERS );

  // check whether 'ah_file' (as registered) affects any of the files given in 'deps'
  // (canonical paths required!)
  bool affects_any(const std::string &ah_file, std::set<std::string> &deps);

private:
  void find_ah_deps(const std::string &ah_file, std::set<std::string> &deps);
};

#endif // __ACDeps_h__
