/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import java.io.Serializable;
import java.util.Map;

public class VCFHeaderLine
implements Comparable,
Serializable {
    public static final long serialVersionUID = 1L;
    protected static final boolean ALLOW_UNBOUND_DESCRIPTIONS = true;
    protected static final String UNBOUND_DESCRIPTION = "Not provided in original VCF header";
    private String mKey = null;
    private String mValue = null;

    public VCFHeaderLine(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("VCFHeaderLine: key cannot be null");
        }
        if (key.contains("<") || key.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: key cannot contain angle brackets");
        }
        if (key.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: key cannot contain an equals sign");
        }
        this.mKey = key;
        this.mValue = value;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getValue() {
        return this.mValue;
    }

    public boolean shouldBeAddedToDictionary() {
        return false;
    }

    public String toString() {
        return this.toStringEncoding();
    }

    protected String toStringEncoding() {
        return this.mKey + "=" + this.mValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VCFHeaderLine that = (VCFHeaderLine)o;
        return this.mKey.equals(that.mKey) && (this.mValue != null ? this.mValue.equals(that.mValue) : that.mValue == null);
    }

    public int hashCode() {
        int result = this.mKey.hashCode();
        result = 31 * result + (this.mValue != null ? this.mValue.hashCode() : 0);
        return result;
    }

    public int compareTo(Object other) {
        return this.toString().compareTo(other.toString());
    }

    public static boolean isHeaderLine(String line) {
        return line != null && line.length() > 0 && "#".equals(line.substring(0, 1));
    }

    public static String toStringEncoding(Map<String, ? extends Object> keyValues) {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        boolean start = true;
        for (Map.Entry<String, ? extends Object> entry : keyValues.entrySet()) {
            if (start) {
                start = false;
            } else {
                builder.append(",");
            }
            if (entry.getValue() == null) {
                throw new TribbleException.InternalCodecException("Header problem: unbound value at " + entry + " from " + keyValues);
            }
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue().toString().contains(",") || entry.getValue().toString().contains(" ") || entry.getKey().equals("Description") ? "\"" + entry.getValue() + "\"" : entry.getValue());
        }
        builder.append(">");
        return builder.toString();
    }
}

