/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private byte[] buf;
    private long realPos;
    private int bufPos;
    private int bufEnd;
    private boolean sync = false;

    public BufferedRandomAccessFile(File f, String mode, int bufSize) throws IOException {
        super(f, mode);
        this.buf = new byte[bufSize];
        this.fillBuffer();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return super.skipBytes(n);
    }

    @Override
    public final int read() throws IOException {
        if (this.bufPos >= this.bufEnd && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.bufEnd == 0) {
            return -1;
        }
        return this.buf[this.bufPos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r;
        int readCount = 0;
        for (int index = off; index < len && (r = this.read()) != -1; ++index) {
            ++readCount;
            b[index] = (byte)r;
        }
        return readCount;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.bufPos >= this.buf.length) {
            this.fillBuffer();
        }
        this.buf[this.bufPos++] = (byte)b;
        if (this.bufPos >= this.bufEnd) {
            this.bufEnd = this.bufPos;
        }
        this.sync = true;
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.realPos;
        return l - (long)this.bufEnd + (long)this.bufPos;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.realPos - pos);
        if (n >= 0 && n <= this.bufEnd) {
            this.bufPos = this.bufEnd - n;
        } else {
            this.sync();
            super.seek(pos);
            this.invalidate();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.sync();
        super.close();
    }

    private void sync() throws IOException {
        if (this.sync) {
            super.seek(this.realPos - (long)this.bufEnd);
            super.write(this.buf, 0, this.bufEnd);
            this.sync = false;
        }
    }

    private int fillBuffer() throws IOException {
        this.sync();
        int n = super.read(this.buf, 0, this.buf.length);
        if (n >= 0) {
            this.realPos += (long)n;
            this.bufEnd = n;
            this.bufPos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.bufEnd = 0;
        this.bufPos = 0;
        this.realPos = super.getFilePointer();
    }

    public static void main(String[] args) throws Exception {
        try {
            File file = new File("tmp.bin");
            if (file.exists()) {
                file.delete();
            }
            BufferedRandomAccessFile f = new BufferedRandomAccessFile(file, "rw", 1);
            f.writeInt(1);
            f.writeInt(2);
            f.writeInt(3);
            f.writeInt(4);
            f.writeInt(5);
            f.seek(0L);
            System.out.println(f.readInt());
            System.out.println(f.readInt());
            f.writeInt(6);
            System.out.println(f.readInt());
            System.out.println(f.readInt());
            f.seek(0L);
            System.out.println(f.readInt());
            System.out.println(f.readInt());
            System.out.println(f.readInt());
            System.out.println(f.readInt());
            System.out.println(f.readInt());
            f.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

