/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree.utils;

import edu.msu.cme.rdp.taxatree.Taxon;
import edu.msu.cme.rdp.taxatree.VisitInfo;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.io.PrintStream;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintVisitor<E extends Taxon>
implements TreeVisitor<E> {
    private char indentCharacter;
    private int indent;
    private PrintStream out;

    public PrintVisitor() {
        this(4, ' ', System.out);
    }

    public PrintVisitor(int indent) {
        this(indent, ' ', System.out);
    }

    public PrintVisitor(int indent, char indentCharacter) {
        this(indent, indentCharacter, System.out);
    }

    public PrintVisitor(int indent, PrintStream out) {
        this(indent, ' ', out);
    }

    public PrintVisitor(PrintStream out) {
        this(4, ' ', out);
    }

    public PrintVisitor(int indent, char indentCharacter, PrintStream out) {
        this.indent = indent;
        this.indentCharacter = indentCharacter;
        this.out = out;
    }

    @Override
    public boolean visitNode(VisitInfo<E> visitInfo) {
        char[] indentChars = new char[visitInfo.getDepth() * this.indent];
        Arrays.fill(indentChars, this.indentCharacter);
        String indentString = new String(indentChars);
        this.out.println(indentString + ((Taxon)visitInfo.getTaxon()).getName() + " rank=" + ((Taxon)visitInfo.getTaxon()).getRank() + " taxid=" + ((Taxon)visitInfo.getTaxon()).getTaxid());
        return true;
    }
}

