/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.TranslationTable;

public class SimpleTranslationTable
implements TranslationTable,
Serializable {
    private final Map transMap;
    private final FiniteAlphabet source;
    private final Alphabet target;

    public SimpleTranslationTable(FiniteAlphabet finiteAlphabet, Alphabet alphabet) {
        this.source = finiteAlphabet;
        this.target = alphabet;
        this.transMap = new HashMap();
    }

    public SimpleTranslationTable(FiniteAlphabet finiteAlphabet, Alphabet alphabet, Map map) {
        this.source = finiteAlphabet;
        this.target = alphabet;
        this.transMap = map;
    }

    public Alphabet getSourceAlphabet() {
        return this.source;
    }

    public Alphabet getTargetAlphabet() {
        return this.target;
    }

    public void setTranslation(AtomicSymbol atomicSymbol, AtomicSymbol atomicSymbol2) throws IllegalSymbolException {
        this.source.validate(atomicSymbol);
        this.target.validate(atomicSymbol2);
        this.transMap.put(atomicSymbol, atomicSymbol2);
    }

    public Symbol translate(Symbol symbol) throws IllegalSymbolException {
        Symbol symbol2 = (Symbol)this.transMap.get(symbol);
        if (symbol2 == null) {
            if (symbol2 instanceof AtomicSymbol) {
                this.getSourceAlphabet().validate(symbol);
                throw new IllegalSymbolException("Unable to map " + symbol.getName());
            }
            if (symbol == null) {
                throw new NullPointerException("Can't translate null");
            }
            HashSet<Symbol> hashSet = new HashSet<Symbol>();
            Iterator iterator = ((FiniteAlphabet)symbol.getMatches()).iterator();
            while (iterator.hasNext()) {
                Symbol symbol3 = (Symbol)iterator.next();
                hashSet.add(this.translate(symbol3));
            }
            symbol2 = this.getTargetAlphabet().getAmbiguity(hashSet);
        }
        return symbol2;
    }
}

