/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

class SwissprotFeatureTableParser {
    private SeqIOListener listener;
    private String featureSource;
    private boolean inFeature = false;
    private Feature.Template featureTemplate;
    private StringBuffer descBuf = new StringBuffer();

    SwissprotFeatureTableParser(SeqIOListener seqIOListener, String string) {
        this.listener = seqIOListener;
        this.featureSource = string;
    }

    public void endFeature() throws BioException {
        if (this.descBuf.length() > 0) {
            this.featureTemplate.annotation = new SimpleAnnotation();
            try {
                this.featureTemplate.annotation.setProperty("swissprot.featureattribute", this.descBuf.toString());
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioException(changeVetoException, "Couldn't alter annotation");
            }
        } else {
            this.featureTemplate.annotation = Annotation.EMPTY_ANNOTATION;
        }
        this.listener.startFeature(this.featureTemplate);
        this.listener.endFeature();
        this.inFeature = false;
    }

    public void featureData(String string) throws BioException {
        boolean bl = false;
        if (string.charAt(5) != ' ') {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.featureTemplate.location = this.getLocation(stringTokenizer);
            string = string.length() >= 20 ? string.substring(20) : "";
            bl = true;
        }
        if (bl) {
            this.descBuf.setLength(0);
        }
        this.descBuf.append(" " + string.trim());
        bl = false;
    }

    private Index getIndex(StringTokenizer stringTokenizer) throws BioException {
        Index index;
        String string = stringTokenizer.nextToken();
        boolean bl = false;
        if (string.indexOf(60) != -1 && string.indexOf(62) != -1) {
            string = string.substring(1);
            bl = true;
        }
        try {
            index = new Index(new Integer(string), bl);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BioException("bad locator: " + string);
        }
        return index;
    }

    private Location getLocation(StringTokenizer stringTokenizer) throws BioException {
        Index index = this.getIndex(stringTokenizer);
        Index index2 = this.getIndex(stringTokenizer);
        Integer n = index.point;
        Integer n2 = index2.point;
        boolean bl = index.isFuzzy;
        boolean bl2 = index2.isFuzzy;
        Serializable serializable = bl || bl2 ? new FuzzyLocation(bl ? Integer.MIN_VALUE : n, bl2 ? Integer.MAX_VALUE : n2, n, n2, FuzzyLocation.RESOLVE_INNER) : (n2.equals(n) ? new PointLocation(n) : new RangeLocation(n, n2));
        return serializable;
    }

    public boolean inFeature() {
        return this.inFeature;
    }

    public void startFeature(String string) throws BioException {
        this.featureTemplate = new Feature.Template();
        this.featureTemplate.source = this.featureSource;
        this.featureTemplate.type = string;
        this.descBuf.setLength(0);
        this.inFeature = true;
    }

    private class Index {
        public boolean isFuzzy;
        public Integer point;

        public Index(Integer n, boolean bl) {
            this.point = n;
            this.isFuzzy = bl;
        }
    }
}

