/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.GenbankContext;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SeqFileFormerFactory;
import org.biojava.bio.seq.io.SeqIOEventEmitter;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

public class GenbankFormat
implements SequenceFormat,
Serializable {
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final String FEATURE_TAG = "FEATURES";
    protected static final String START_SEQUENCE_TAG = "ORIGIN";
    protected static final String FEATURE_LINE_PREFIX = "     ";
    protected static final String FEATURE_FLAG = "FT";
    protected static final String ACCESSION_TAG = "ACCESSION";
    protected static final String LOCUS_TAG = "LOCUS";
    protected static final String SIZE_TAG = "SIZE";
    protected static final String TYPE_TAG = "TYPE";
    protected static final String STRAND_NUMBER_TAG = "STRANDS";
    protected static final String CIRCULAR_TAG = "CIRCULAR";
    protected static final String DIVISION_TAG = "DIVISION";
    protected static final String DATE_TAG = "MDAT";
    protected static final String VERSION_TAG = "VERSION";
    protected static final String GI_TAG = "GI";
    static /* synthetic */ Class class$org$biojava$bio$seq$io$GenbankFormat;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Genbank");
        SequenceFormat.FORMATS.put((class$org$biojava$bio$seq$io$GenbankFormat != null ? class$org$biojava$bio$seq$io$GenbankFormat : (class$org$biojava$bio$seq$io$GenbankFormat = GenbankFormat.class$("org.biojava.bio.seq.io.GenbankFormat"))).getName(), hashSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getDefaultFormat() {
        return "Genbank";
    }

    public Set getFormats() {
        return (Set)SequenceFormat.FORMATS.get(this.getClass().getName());
    }

    public boolean readSequence(BufferedReader bufferedReader, SymbolParser symbolParser, SeqIOListener seqIOListener) throws IllegalSymbolException, IOException, ParseException {
        String string;
        GenbankContext genbankContext = new GenbankContext(symbolParser, seqIOListener);
        StreamParser streamParser = null;
        boolean bl = true;
        seqIOListener.startSequence();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0) continue;
            if (string.startsWith(END_SEQUENCE_TAG)) {
                if (streamParser != null) {
                    streamParser.close();
                    streamParser = null;
                }
                bufferedReader.mark(2);
                if (bufferedReader.read() == -1) {
                    bl = false;
                } else {
                    bufferedReader.reset();
                }
                seqIOListener.endSequence();
                return bl;
            }
            genbankContext.processLine(string);
        }
        throw new IOException("Premature end of stream for GENBANK");
    }

    public void writeSequence(Sequence sequence, PrintStream printStream) throws IOException {
        try {
            String string = this.getDefaultFormat();
            SeqFileFormer seqFileFormer = SeqFileFormerFactory.makeFormer(string);
            seqFileFormer.setPrintStream(printStream);
            SeqIOEventEmitter.getSeqIOEvents(sequence, seqFileFormer);
        }
        catch (BioException bioException) {
            bioException.printStackTrace();
        }
    }

    public void writeSequence(Sequence sequence, String string, PrintStream printStream) throws IOException {
        String string2 = new String(string);
        boolean bl = false;
        try {
            String[] stringArray = this.getFormats().toArray(new String[0]);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    string2 = stringArray[n];
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                throw new BioException("An invalid file format '" + string + "' was requested");
            }
            SeqFileFormer seqFileFormer = SeqFileFormerFactory.makeFormer(string2);
            SeqIOEventEmitter.getSeqIOEvents(sequence, seqFileFormer);
        }
        catch (BioException bioException) {
            bioException.printStackTrace();
        }
    }
}

