/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DataSource;
import org.biojava.bio.program.das.ReferenceServer;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DAS
extends AbstractChangeable {
    private Map dataSources = new HashMap();
    public static final ChangeType SERVERS = new ChangeType("Das Servers changed", class$org$biojava$bio$program$das$DAS != null ? class$org$biojava$bio$program$das$DAS : (class$org$biojava$bio$program$das$DAS = DAS.class$("org.biojava.bio.program.das.DAS")), "SERVERS");
    static /* synthetic */ Class class$org$biojava$bio$program$das$DAS;

    public void addDasURL(URL uRL) throws BioException, ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SERVERS);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SERVERS);
                changeSupport.firePreChangeEvent(changeEvent);
                this.addDasURLImpl(uRL);
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.addDasURLImpl(uRL);
        }
    }

    private void addDasURLImpl(URL uRL) throws BioException, ChangeVetoException {
        try {
            URL uRL2 = new URL(uRL, "dsn");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            httpURLConnection.connect();
            int n = httpURLConnection.getHeaderFieldInt("X-DAS-Status", 0);
            if (n == 0) {
                throw new BioException("Not a DAS server");
            }
            if (n != 200) {
                throw new BioException("DAS error (status code = " + n + ")");
            }
            InputSource inputSource = new InputSource(httpURLConnection.getInputStream());
            DOMParser dOMParser = DASSequence.nonvalidatingParser();
            dOMParser.parse(inputSource);
            NodeList nodeList = dOMParser.getDocument().getDocumentElement().getElementsByTagName("DSN");
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Node node = nodeList.item(n2);
                if (node instanceof Element) {
                    DataSource dataSource;
                    Element element = (Element)node;
                    Element element2 = (Element)element.getElementsByTagName("SOURCE").item(0);
                    Element element3 = (Element)element.getElementsByTagName("MAPMASTER").item(0);
                    Element element4 = (Element)element.getElementsByTagName("DESCRIPTION").item(0);
                    String string = element2.getAttribute("id");
                    String string2 = ((Text)element2.getFirstChild()).getData();
                    URL uRL3 = new URL(((Text)element3.getFirstChild()).getData());
                    String string3 = ((Text)element4.getFirstChild()).getData();
                    URL uRL4 = new URL(uRL, String.valueOf(string) + "/");
                    ReferenceServer referenceServer = (ReferenceServer)this.dataSources.get(uRL3);
                    if (uRL4.equals(uRL3)) {
                        dataSource = new ReferenceServer(uRL4, string2, string3);
                        if (referenceServer != null) {
                            Iterator iterator = referenceServer.getAnnotaters().iterator();
                            while (iterator.hasNext()) {
                                ((ReferenceServer)dataSource).addAnnotator((DataSource)iterator.next());
                            }
                        }
                        this.dataSources.put(uRL4, dataSource);
                    } else {
                        if (referenceServer == null) {
                            referenceServer = new ReferenceServer(uRL3, null, null);
                            this.dataSources.put(uRL3, referenceServer);
                        }
                        dataSource = new DataSource(uRL4, uRL3, string2, string3);
                        referenceServer.addAnnotator(dataSource);
                    }
                }
                ++n2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new BioException(malformedURLException, "Can't build DAS url");
        }
        catch (IOException iOException) {
            throw new BioException(iOException, "Can't process URL connection");
        }
        catch (SAXException sAXException) {
            throw new BioException(sAXException, "Can't parse XML document");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Set getReferenceServers() {
        return Collections.unmodifiableSet(new HashSet(this.dataSources.values()));
    }
}

