/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class SymbolSequenceRenderer
implements SequenceRenderer {
    private double depth = 25.0;

    public double getDepth(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return this.depth + 1.0;
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return 0.0;
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        SymbolList symbolList = sequenceRenderContext.getSequence();
        int n = sequenceRenderContext.getDirection();
        graphics2D.setFont(sequenceRenderContext.getFont());
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(Color.black);
        double d = sequenceRenderContext.getScale();
        Rectangle2D rectangle2D = graphics2D.getFont().getMaxCharBounds(graphics2D.getFontRenderContext());
        if (sequenceRenderContext.getScale() >= rectangle2D.getWidth() * 0.3 && sequenceRenderContext.getScale() >= rectangle2D.getHeight() * 0.3) {
            int n2;
            int n3;
            double d2 = 0.0;
            double d3 = 0.0;
            if (n == 0) {
                d2 = 0.0;
                d3 = this.depth * 0.5 - rectangle2D.getCenterY();
            } else {
                d2 = this.depth * 0.5 - rectangle2D.getCenterX();
                d3 = d * 0.5 - rectangle2D.getCenterY();
            }
            if (sequenceRenderContext.getDirection() == 0) {
                n3 = sequenceRenderContext.graphicsToSequence(rectangle.getMinX());
                n2 = sequenceRenderContext.graphicsToSequence(rectangle.getMaxX());
            } else {
                n3 = sequenceRenderContext.graphicsToSequence(rectangle.getMinY());
                n2 = sequenceRenderContext.graphicsToSequence(rectangle.getMaxY());
            }
            int n4 = Math.max(rangeLocation.getMin(), n3);
            int n5 = Math.min(rangeLocation.getMax(), n2 + 1);
            int n6 = n4;
            while (n6 <= n5) {
                double d4 = sequenceRenderContext.sequenceToGraphics(n6);
                char c = symbolList.symbolAt(n6).getToken();
                if (n == 0) {
                    graphics2D.drawString(String.valueOf(c), (int)(d4 + d2), (int)d3);
                } else {
                    graphics2D.drawString(String.valueOf(c), (int)d2, (int)(d4 + d3));
                }
                ++n6;
            }
        }
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext sequenceRenderContext, MouseEvent mouseEvent, List list, RangeLocation rangeLocation) {
        list.add(this);
        int n = sequenceRenderContext.graphicsToSequence(mouseEvent.getPoint());
        return new SequenceViewerEvent(this, null, n, mouseEvent, list);
    }
}

