/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.DistributionLogo;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class BarLogoPainter
implements LogoPainter {
    public void paintLogo(Graphics graphics, DistributionLogo distributionLogo) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Distribution distribution = distributionLogo.getDistribution();
        SymbolStyle symbolStyle = distributionLogo.getStyle();
        Rectangle rectangle = distributionLogo.getBounds();
        double d = rectangle.getWidth();
        double d2 = d / (double)((FiniteAlphabet)distribution.getAlphabet()).size();
        double d3 = rectangle.getHeight();
        double d4 = d3 * (distributionLogo.totalInformation() / distributionLogo.totalBits());
        double d5 = 0.0;
        Iterator iterator = ((FiniteAlphabet)distribution.getAlphabet()).iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            double d6 = 0.0;
            try {
                d6 = distribution.getWeight(symbol) * d4;
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "State alphabet has changed while painting");
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d3 - d6, d2, d6);
            try {
                graphics2D.setPaint(symbolStyle.fillPaint(symbol));
            }
            catch (IllegalSymbolException illegalSymbolException) {
                graphics2D.setPaint(Color.black);
            }
            graphics2D.fill(double_);
            try {
                graphics2D.setPaint(symbolStyle.outlinePaint(symbol));
            }
            catch (IllegalSymbolException illegalSymbolException) {
                graphics2D.setPaint(Color.gray);
            }
            graphics2D.draw(double_);
            d5 += d2;
        }
    }
}

