/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.AbstractTrainer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class BaumWelchTrainer
extends AbstractTrainer
implements Serializable {
    public BaumWelchTrainer(DP dP) {
        super(dP);
    }

    protected double singleSequenceIteration(ModelTrainer modelTrainer, SymbolList symbolList) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException {
        double[] dArray;
        double[] dArray2;
        ScoreType scoreType = ScoreType.PROBABILITY;
        DP dP = this.getDP();
        State[] stateArray = dP.getStates();
        int[][] nArray = dP.getForwardTransitions();
        double[][] dArray3 = dP.getForwardTransitionScores(scoreType);
        int[][] nArray2 = dP.getBackwardTransitions();
        double[][] dArray4 = dP.getBackwardTransitionScores(scoreType);
        MarkovModel markovModel = dP.getModel();
        SymbolList[] symbolListArray = new SymbolList[]{symbolList};
        SingleDPMatrix singleDPMatrix = (SingleDPMatrix)dP.forwardMatrix(symbolListArray, scoreType);
        double d = singleDPMatrix.getScore();
        SingleDPMatrix singleDPMatrix2 = (SingleDPMatrix)dP.backwardMatrix(symbolListArray, scoreType);
        double d2 = singleDPMatrix2.getScore();
        Symbol symbol = AlphabetManager.getGapSymbol();
        int n = 1;
        while (n <= symbolList.length()) {
            Symbol symbol2 = symbolList.symbolAt(n);
            int n2 = 0;
            while (n2 < dP.getDotStatesIndex()) {
                dArray2 = singleDPMatrix.scores[n];
                dArray = singleDPMatrix2.scores[n];
                if (!(stateArray[n2] instanceof MagicalState)) {
                    modelTrainer.addCount(((EmissionState)stateArray[n2]).getDistribution(), symbol2, Math.exp(dArray2[n2] + dArray[n2] - d));
                }
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 <= symbolList.length()) {
            Symbol symbol3 = n3 < symbolList.length() ? symbolList.symbolAt(n3 + 1) : symbol;
            dArray2 = singleDPMatrix.scores[n3];
            dArray = singleDPMatrix2.scores[n3 + 1];
            int n4 = 0;
            while (n4 < stateArray.length) {
                int[] nArray3 = nArray2[n4];
                double[] dArray5 = dArray4[n4];
                Distribution distribution = markovModel.getWeights(stateArray[n4]);
                int n5 = 0;
                while (n5 < nArray3.length) {
                    double d3;
                    int n6 = nArray3[n5];
                    double d4 = d3 = stateArray[n6] instanceof EmissionState ? ((EmissionState)stateArray[n6]).getDistribution().getWeight(symbol3) : 1.0;
                    if (d3 != 0.0) {
                        try {
                            modelTrainer.addCount(distribution, stateArray[n6], Math.exp(dArray2[n4] + dArray5[n5] + dArray[n6] - d) * d3);
                        }
                        catch (IllegalSymbolException illegalSymbolException) {
                            throw new BioError(illegalSymbolException, "Transition in backwardTransitions[][] dissapeared");
                        }
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return d;
    }
}

