/*
 * Decompiled with CFR 0.152.
 */
package org.acedb.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.acedb.AceError;
import org.acedb.AceException;
import org.acedb.Connection;

class AceSocket
implements Connection {
    private static final int OK_MAGIC = 305419896;
    private static final String MSGREQ = "ACESERV_MSGREQ";
    private static final String MSGDATA = "ACESERV_MSGDATA";
    private static final String MSGOK = "ACESERV_MSGOK";
    private static final String MSGENCORE = "ACESERV_MSGENCORE";
    private static final String MSGFAIL = "ACESERV_MSGFAIL";
    private static final String MSGKILL = "ACESERV_MSGKILL";
    private Socket sock;
    private DataInputStream dis;
    private DataOutputStream dos;
    private boolean pendingConfig = true;
    private int serverVersion = 0;
    private int clientId = 0;
    private int encore = 0;
    private int maxBytes = 0;
    private boolean defunct = false;

    public AceSocket(String string, int n, String string2, String string3) throws AceException {
        try {
            this.sock = new Socket(string, n);
            this.dis = new DataInputStream(this.sock.getInputStream());
            this.dos = new DataOutputStream(this.sock.getOutputStream());
            String string4 = this.transact("bonjour");
            String string5 = AceSocket.md5Sum(string2, string3);
            String string6 = AceSocket.md5Sum(string5, string4);
            String string7 = this.transact(String.valueOf(string2) + " " + string6);
            if (!string7.startsWith("et bonjour a vous")) {
                throw new AceException("Couldn't connect (" + string7 + ")");
            }
        }
        catch (IOException iOException) {
            throw new AceException(iOException);
        }
    }

    public void dispose() throws AceException {
        try {
            this.defunct = true;
            this.sock.close();
        }
        catch (IOException iOException) {
            throw new AceException(iOException);
        }
    }

    private void handleUnsolicited() throws AceException {
        this.defunct = true;
        throw new AceException("Unsolicited data from server!", true);
    }

    private static char hexChar(int n) {
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(97 + n - 10);
    }

    public boolean isDefunct() {
        return this.defunct;
    }

    private static String md5Sum(String string, String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest(string2.getBytes());
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < byArray.length) {
                byte by = byArray[n];
                stringBuffer.append(AceSocket.hexChar(by >>> 4 & 0xF));
                stringBuffer.append(AceSocket.hexChar(by & 0xF));
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AceError("BioJava access to ACeDB sockets require the MD5 hash algorithm.  Consult your Java Vendor.");
        }
    }

    private String readMessage() throws IOException {
        int n = this.dis.readInt();
        int n2 = this.dis.readInt();
        int n3 = this.dis.readInt();
        int n4 = this.dis.readInt();
        int n5 = this.dis.readInt();
        byte[] byArray = new byte[30];
        this.dis.readFully(byArray);
        String string = new String(byArray);
        if (this.pendingConfig) {
            this.serverVersion = n3;
            this.clientId = n4;
            this.maxBytes = n5;
            this.pendingConfig = false;
        }
        byte[] byArray2 = new byte[n2 - 1];
        this.dis.readFully(byArray2);
        this.dis.skipBytes(1);
        if (string.startsWith(MSGENCORE)) {
            this.writeMessage(MSGREQ, "encore");
            return String.valueOf(new String(byArray2)) + this.readMessage();
        }
        return new String(byArray2);
    }

    public String transact(String string) throws AceException {
        try {
            if (this.dis.available() != 0) {
                this.handleUnsolicited();
            }
            this.writeMessage(MSGREQ, string);
            String string2 = this.readMessage();
            return string2;
        }
        catch (IOException iOException) {
            throw new AceException(iOException);
        }
    }

    private void writeMessage(String string, String string2) throws IOException {
        this.dos.writeInt(305419896);
        this.dos.writeInt(string2.length() + 1);
        this.dos.writeInt(this.serverVersion);
        this.dos.writeInt(this.clientId);
        this.dos.writeInt(this.maxBytes);
        this.dos.writeBytes(string);
        byte[] byArray = new byte[30 - string.length()];
        this.dos.write(byArray, 0, byArray.length);
        this.dos.writeBytes(string2);
        this.dos.write(0);
        this.dos.flush();
    }
}

