/*
 * Decompiled with CFR 0.152.
 */
package org.acedb.seq;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.acedb.Ace;
import org.acedb.AceError;
import org.acedb.AceException;
import org.acedb.AceObject;
import org.acedb.AceSet;
import org.acedb.AceURL;
import org.acedb.seq.AceSequence;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class AceSequenceDB
implements SequenceDB {
    protected AceSet seqSet;

    public AceSequenceDB(AceURL aceURL) throws AceException {
        this(aceURL, "*");
    }

    public AceSequenceDB(AceURL aceURL, String string) throws AceException {
        AceURL aceURL2 = new AceURL(aceURL.getProtocol(), aceURL.getHost(), aceURL.getPort(), "Sequence", string, aceURL.getRef(), aceURL.getUserInfo(), aceURL.getAuthority());
        this.seqSet = Ace.fetch(aceURL2);
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void addSequence(Sequence sequence) throws ChangeVetoException {
        throw new ChangeVetoException("SequenceDBAdapter is immutable");
    }

    public String getName() {
        return this.seqSet.getName();
    }

    public Sequence getSequence(String string) throws BioException {
        try {
            return new AceSequence((AceObject)this.seqSet.retrieve(string));
        }
        catch (AceException aceException) {
            throw new BioException(aceException, "unable to retrieve sequence " + string);
        }
    }

    public Set ids() {
        return new AbstractSet(){

            public boolean contains(Object object) {
                if (!(object instanceof String)) {
                    return false;
                }
                try {
                    return AceSequenceDB.this.seqSet.contains((String)object);
                }
                catch (AceException aceException) {
                    throw new AceError(aceException, "Couldn't retrieve set size");
                }
            }

            public Iterator iterator() {
                try {
                    return AceSequenceDB.this.seqSet.nameIterator();
                }
                catch (AceException aceException) {
                    throw new AceError(aceException, "Couldn't retrieve set size");
                }
            }

            public int size() {
                try {
                    return AceSequenceDB.this.seqSet.size();
                }
                catch (AceException aceException) {
                    throw new AceError(aceException, "Couldn't retrieve set size");
                }
            }
        };
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeSequence(String string) throws ChangeVetoException {
        throw new ChangeVetoException("SequenceDBAdapter is immutable");
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            Iterator id;
            {
                this.id = AceSequenceDB.this.ids().iterator();
            }

            public boolean hasNext() {
                return this.id.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return AceSequenceDB.this.getSequence((String)this.id.next());
            }
        };
    }
}

