/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.BasisFunctionWithHistory;
import eponine.model.BundleConstraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import eponine.model.WeightMatrixConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.SLMTrainingContext;

public class AppendColumnBasisSource
extends FundamentalAtomicSymbol
implements BasisSource {
    private double nullModelWeighting = 1.0;
    private int sampleCounts = 13;
    private String name = "addcol";

    public AppendColumnBasisSource() {
        super("addcol", ' ', Annotation.EMPTY_ANNOTATION);
    }

    public void setNullModelWeighting(double d) {
        this.nullModelWeighting = d;
    }

    public void setSampleCounts(int n) {
        this.sampleCounts = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        Object object;
        Object object2;
        List list = sLMTrainingContext.getBasisList();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (BasisFunction)iterator.next();
            object = ModelTools.removeHistory((BasisFunction)object2);
            if (!(object instanceof ConstraintBasisFunction)) continue;
            PositionedConstraint positionedConstraint = (PositionedConstraint)((ConstraintBasisFunction)object).getConstraint();
            int n2 = 1;
            if (positionedConstraint.getConstraint() instanceof BundleConstraint) {
                n2 = ((BundleConstraint)positionedConstraint.getConstraint()).getConstraints().size();
            }
            hashMap.put(object2, new Integer(n2));
            n += n2;
        }
        try {
            n = (int)Math.ceil((double)n * Math.random());
            object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                int n3 = (Integer)object.getValue();
                if ((n -= n3) > 0) continue;
                BasisFunction basisFunction = (BasisFunction)object.getKey();
                PositionedConstraint positionedConstraint = (PositionedConstraint)ModelTools.getConstraint(basisFunction);
                if (n3 == 1) {
                    WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint.getConstraint();
                    weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint);
                    return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(weightMatrixConstraint, positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
                }
                ArrayList<PositionedConstraint> arrayList = new ArrayList<PositionedConstraint>(((BundleConstraint)positionedConstraint.getConstraint()).getConstraints());
                PositionedConstraint positionedConstraint2 = (PositionedConstraint)arrayList.get(-n);
                WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint2.getConstraint();
                weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint);
                arrayList.set(-n, new PositionedConstraint(weightMatrixConstraint, positionedConstraint2.getPosition(), positionedConstraint2.getDistribution(), positionedConstraint2.isMaximum()));
                return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(new BundleConstraint(arrayList), positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
            }
        }
        catch (BioException bioException) {
            return null;
        }
        System.out.println("totalProb exceeded");
        return null;
    }

    private WeightMatrixConstraint sampleWeightMatrixConstraint(WeightMatrixConstraint weightMatrixConstraint) throws BioException {
        WeightMatrix weightMatrix = weightMatrixConstraint.getWeightMatrix();
        SimpleWeightMatrix simpleWeightMatrix = null;
        WeightMatrixConstraint weightMatrixConstraint2 = null;
        if (weightMatrix.getAlphabet().getAlphabets().size() > 1) {
            throw new IllegalAlphabetException();
        }
        if (weightMatrix.columns() < 20) {
            Object object;
            Object object2;
            Distribution distribution;
            simpleWeightMatrix = new SimpleWeightMatrix(weightMatrix.getAlphabet(), weightMatrix.columns() + 1, DistributionFactory.DEFAULT);
            int n = (int)Math.round(Math.random());
            int n2 = 0;
            while (n2 < weightMatrix.columns()) {
                Distribution distribution2 = weightMatrix.getColumn(n2);
                distribution = simpleWeightMatrix.getColumn(n2 + n);
                object2 = ((FiniteAlphabet)weightMatrix.getAlphabet()).iterator();
                while (object2.hasNext()) {
                    object = (Symbol)object2.next();
                    try {
                        distribution.setWeight((Symbol)object, distribution2.getWeight((Symbol)object));
                    }
                    catch (ChangeVetoException changeVetoException) {
                        throw new BioError(changeVetoException);
                    }
                }
                ++n2;
            }
            int n3 = n == 0 ? simpleWeightMatrix.columns() - 1 : 0;
            distribution = simpleWeightMatrix.getColumn(n3);
            object2 = distribution.getNullModel();
            object = new SimpleDistributionTrainerContext();
            ((SimpleDistributionTrainerContext)object).setNullModelWeight(this.nullModelWeighting);
            ((SimpleDistributionTrainerContext)object).registerDistribution(distribution);
            int n4 = 0;
            while (n4 < this.sampleCounts) {
                ((SimpleDistributionTrainerContext)object).addCount(distribution, object2.sampleSymbol(), 1.0);
                ++n4;
            }
            try {
                ((SimpleDistributionTrainerContext)object).train();
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException);
            }
        } else {
            throw new BioException("That WM is far too long!");
        }
        weightMatrixConstraint2 = new WeightMatrixConstraint(simpleWeightMatrix, weightMatrixConstraint.getReversibility());
        return weightMatrixConstraint2;
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        return sLMTrainingContext.getCurrentCycle() > 0 && sLMTrainingContext.getBasisList().size() >= 3;
    }
}

