/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    private DoubleMatrix2D L;
    private int n;
    private boolean isSymmetricPositiveDefinite;

    public CholeskyDecomposition(DoubleMatrix2D doubleMatrix2D) {
        Property.DEFAULT.checkSquare(doubleMatrix2D);
        this.n = doubleMatrix2D.rows();
        this.L = doubleMatrix2D.like(this.n, this.n);
        this.isSymmetricPositiveDefinite = doubleMatrix2D.columns() == this.n;
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[this.n];
        int n = 0;
        while (n < this.n) {
            doubleMatrix1DArray[n] = this.L.viewRow(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.n) {
            double d = 0.0;
            int n3 = 0;
            while (n3 < n2) {
                double d2 = doubleMatrix1DArray[n3].zDotProduct(doubleMatrix1DArray[n2], 0, n3);
                d2 = (doubleMatrix2D.getQuick(n2, n3) - d2) / this.L.getQuick(n3, n3);
                doubleMatrix1DArray[n2].setQuick(n3, d2);
                d += d2 * d2;
                this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && doubleMatrix2D.getQuick(n3, n2) == doubleMatrix2D.getQuick(n2, n3);
                ++n3;
            }
            d = doubleMatrix2D.getQuick(n2, n2) - d;
            this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && d > 0.0;
            this.L.setQuick(n2, n2, Math.sqrt(Math.max(d, 0.0)));
            int n4 = n2 + 1;
            while (n4 < this.n) {
                this.L.setQuick(n2, n4, 0.0);
                ++n4;
            }
            ++n2;
        }
    }

    public DoubleMatrix2D getL() {
        return this.L;
    }

    public boolean isSymmetricPositiveDefinite() {
        return this.isSymmetricPositiveDefinite;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D doubleMatrix2D) {
        int n;
        Functions functions = Functions.functions;
        if (doubleMatrix2D.rows() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isSymmetricPositiveDefinite) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        int n2 = doubleMatrix2D.columns();
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[this.n];
        int n3 = 0;
        while (n3 < this.n) {
            doubleMatrix1DArray[n3] = doubleMatrix2D2.viewRow(n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.n) {
            n = n4 + 1;
            while (n < this.n) {
                doubleMatrix1DArray[n].assign(doubleMatrix1DArray[n4], Functions.minusMult(this.L.getQuick(n, n4)));
                ++n;
            }
            doubleMatrix1DArray[n4].assign(Functions.div(this.L.getQuick(n4, n4)));
            ++n4;
        }
        n = this.n - 1;
        while (n >= 0) {
            doubleMatrix1DArray[n].assign(Functions.div(this.L.getQuick(n, n)));
            int n5 = 0;
            while (n5 < n) {
                doubleMatrix1DArray[n5].assign(doubleMatrix1DArray[n], Functions.minusMult(this.L.getQuick(n, n5)));
                ++n5;
            }
            --n;
        }
        return doubleMatrix2D2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("--------------------------------------------------------------------------\n");
        stringBuffer.append("CholeskyDecomposition(A) --> isSymmetricPositiveDefinite(A), L, inverse(A)\n");
        stringBuffer.append("--------------------------------------------------------------------------\n");
        stringBuffer.append("isSymmetricPositiveDefinite = ");
        try {
            stringBuffer.append(String.valueOf(this.isSymmetricPositiveDefinite()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nL = ");
        try {
            stringBuffer.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\ninverse(A) = ");
        try {
            stringBuffer.append(String.valueOf(this.solve(DoubleFactory2D.dense.identity(this.L.rows()))));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

