/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.function.LongObjectProcedure;
import cern.colt.function.LongProcedure;
import cern.colt.list.ByteArrayList;
import cern.colt.list.LongArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.AbstractLongObjectMap;
import cern.colt.map.HashFunctions;

public class OpenLongObjectHashMap
extends AbstractLongObjectMap {
    protected long[] table;
    protected Object[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenLongObjectHashMap() {
        this(277);
    }

    public OpenLongObjectHashMap(int n) {
        this(n, 0.2, 0.5);
    }

    public OpenLongObjectHashMap(int n, double d, double d2) {
        this.setUp(n, d, d2);
    }

    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        new ObjectArrayList(this.values).fillFromToWith(0, this.state.length - 1, null);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenLongObjectHashMap openLongObjectHashMap = (OpenLongObjectHashMap)super.clone();
        openLongObjectHashMap.table = (long[])openLongObjectHashMap.table.clone();
        openLongObjectHashMap.values = (Object[])openLongObjectHashMap.values.clone();
        openLongObjectHashMap.state = (byte[])openLongObjectHashMap.state.clone();
        return openLongObjectHashMap;
    }

    public boolean containsKey(long l) {
        return this.indexOfKey(l) >= 0;
    }

    public boolean containsValue(Object object) {
        return this.indexOfValue(object) >= 0;
    }

    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    public boolean forEachKey(LongProcedure longProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || longProcedure.apply(this.table[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(LongObjectProcedure longObjectProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || longObjectProcedure.apply(this.table[n], this.values[n])) continue;
            return false;
        }
        return true;
    }

    public Object get(long l) {
        int n = this.indexOfKey(l);
        if (n < 0) {
            return null;
        }
        return this.values[n];
    }

    protected int indexOfInsertion(long l) {
        long[] lArray = this.table;
        byte[] byArray = this.state;
        int n = lArray.length;
        int n2 = HashFunctions.hash(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 / n % n;
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] == 1 && lArray[n3] != l) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            if (byArray[n3] == 0) {
                n3 = n5;
            }
        }
        if (byArray[n3] == 1) {
            return -n3 - 1;
        }
        return n3;
    }

    protected int indexOfKey(long l) {
        long[] lArray = this.table;
        byte[] byArray = this.state;
        int n = lArray.length;
        int n2 = HashFunctions.hash(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 / n % n;
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 0) {
            return -1;
        }
        return n3;
    }

    protected int indexOfValue(Object object) {
        Object[] objectArray = this.values;
        byte[] byArray = this.state;
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] != 1 || objectArray[n] != object) continue;
            return n;
        }
        return -1;
    }

    public long keyOf(Object object) {
        int n = this.indexOfValue(object);
        if (n < 0) {
            return Long.MIN_VALUE;
        }
        return this.table[n];
    }

    public void keys(LongArrayList longArrayList) {
        longArrayList.setSize(this.distinct);
        long[] lArray = longArrayList.elements();
        long[] lArray2 = this.table;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = lArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            lArray[n++] = lArray2[n2];
        }
    }

    public void pairsMatching(LongObjectProcedure longObjectProcedure, LongArrayList longArrayList, ObjectArrayList objectArrayList) {
        longArrayList.clear();
        objectArrayList.clear();
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || !longObjectProcedure.apply(this.table[n], this.values[n])) continue;
            longArrayList.add(this.table[n]);
            objectArrayList.add(this.values[n]);
        }
    }

    public boolean put(long l, Object object) {
        int n = this.indexOfInsertion(l);
        if (n < 0) {
            n = -n - 1;
            this.values[n] = object;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n2 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
            return this.put(l, object);
        }
        this.table[n] = l;
        this.values[n] = object;
        if (this.state[n] == 0) {
            --this.freeEntries;
        }
        this.state[n] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n3 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        long[] lArray = this.table;
        Object[] objectArray = this.values;
        byte[] byArray = this.state;
        long[] lArray2 = new long[n];
        Object[] objectArray2 = new Object[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = lArray2;
        this.values = objectArray2;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.indexOfInsertion(l);
            lArray2[n4] = l;
            objectArray2[n4] = objectArray[n3];
            byArray2[n4] = 1;
        }
    }

    public boolean removeKey(long l) {
        int n = this.indexOfKey(l);
        if (n < 0) {
            return false;
        }
        this.state[n] = 2;
        this.values[n] = null;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n2 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
        }
        return true;
    }

    protected void setUp(int n, double d, double d2) {
        int n2 = n;
        super.setUp(n2, d, d2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new long[n2];
        this.values = new Object[n2];
        this.state = new byte[n2];
        this.minLoadFactor = d;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0 : d2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    public void values(ObjectArrayList objectArrayList) {
        objectArrayList.setSize(this.distinct);
        Object[] objectArray = objectArrayList.elements();
        Object[] objectArray2 = this.values;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            objectArray[n++] = objectArray2[n2];
        }
    }
}

