## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, fig.wide = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("mitology")

## ----echo=FALSE, fig.wide=FALSE-----------------------------------------------
knitr::include_graphics("figures/MitoCarta_gene_sets.png")
# <img src=./figures/MitoCarta_gene_sets.png class="center" />

## ----echo=FALSE, fig.wide=FALSE-----------------------------------------------
knitr::include_graphics("figures/GO_gene_sets.png")
# <img src=./figures/GO_gene_sets.png class="center" />

## ----echo=FALSE, fig.wide=FALSE-----------------------------------------------
knitr::include_graphics("figures/Reactome_gene_sets.png")
# <img src=./figures/Reactome_gene_sets.png class="center" />

## ----message=FALSE------------------------------------------------------------
library(mitology)
MC_df <- getGeneSets(
    database = "MitoCarta", nametype = "SYMBOL", objectType = "dataframe")

MC_list <- getGeneSets(
    database = "MitoCarta", nametype = "SYMBOL", objectType = "list")

## ----message=FALSE------------------------------------------------------------
# loading packages
library(SummarizedExperiment)
library(clusterProfiler)
library(GSVA)
library(Biobase)

## -----------------------------------------------------------------------------
# load data
data(ovse)
ovse

## -----------------------------------------------------------------------------
genes <- rownames(ovse)[elementMetadata(ovse)$PROvsIMR_FDR < 0.001]
res_ora <- enricher(gene = genes, TERM2GENE = MC_df)

## -----------------------------------------------------------------------------
gsvaPar <- ssgseaParam(exprData = ovse, geneSets = MC_list)
res_ssGSEA <- gsva(gsvaPar)

## -----------------------------------------------------------------------------
res_ssGSEA_subtype <- do.call(
    cbind, lapply(unique(ovse$OV_subtype), function(x){
        rowMeans(assay(res_ssGSEA)[,ovse$OV_subtype==x])
    }))
colnames(res_ssGSEA_subtype) <- unique(ovse$OV_subtype)
rownames(res_ssGSEA_subtype) <- rownames(res_ssGSEA)
res_ssGSEA_subtype <- t(scale(t(res_ssGSEA_subtype)))

## ----message=FALSE------------------------------------------------------------
mitoTreeHeatmap(
    data = res_ssGSEA_subtype, database = "MitoCarta", 
    labelNames = "leaves", font.size = 1)

## ----message=FALSE------------------------------------------------------------
mitoTreeHeatmap(
    data = res_ssGSEA_subtype, database = "MitoCarta",
    labelNames = "sections", font.size = 3)

## -----------------------------------------------------------------------------
sessionInfo()

